/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.transactions.TaxDetails;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.stream.Stream;

public class DefaultTaxDetails
implements TaxDetails {
    private String merchantTaxId;
    private BigDecimal includedTaxAmount;
    private BigDecimal includedLocalTaxAmount;
    private BigDecimal includedNationalTaxAmount;
    private Integer salesSlipNumber;

    public String getMerchantTaxId() {
        return this.merchantTaxId;
    }

    public BigDecimal getIncludedTaxAmount() {
        return this.includedTaxAmount;
    }

    public BigDecimal getIncludedLocalTaxAmount() {
        return this.includedLocalTaxAmount;
    }

    public BigDecimal getIncludedNationalTaxAmount() {
        return this.includedNationalTaxAmount;
    }

    public Integer getSalesSlipNumber() {
        return this.salesSlipNumber;
    }

    public void setMerchantTaxId(String merchantTaxId) {
        this.merchantTaxId = merchantTaxId;
    }

    public void setIncludedTaxAmount(BigDecimal includedTaxAmount) {
        this.includedTaxAmount = includedTaxAmount;
    }

    public void setIncludedLocalTaxAmount(BigDecimal includedLocalTaxAmount) {
        this.includedLocalTaxAmount = includedLocalTaxAmount;
    }

    public void setIncludedNationalTaxAmount(BigDecimal includedNationalTaxAmount) {
        this.includedNationalTaxAmount = includedNationalTaxAmount;
    }

    public void setSalesSlipNumber(Integer salesSlipNumber) {
        this.salesSlipNumber = salesSlipNumber;
    }

    public String toString() {
        return "DefaultTaxDetails{merchantTaxId=" + this.merchantTaxId + "includedTaxAmount=" + this.includedTaxAmount + ", includedLocalTaxAmount=" + this.includedLocalTaxAmount + ", includedNationalTaxAmount=" + this.includedNationalTaxAmount + ", salesSlipNumber=" + this.salesSlipNumber + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DefaultTaxDetails defaultTaxDetails = (DefaultTaxDetails)o2;
        if (!Objects.equals(this.merchantTaxId, defaultTaxDetails.merchantTaxId)) {
            return false;
        }
        if (!Objects.equals(this.includedTaxAmount, defaultTaxDetails.includedTaxAmount)) {
            return false;
        }
        if (!Objects.equals(this.includedLocalTaxAmount, defaultTaxDetails.includedLocalTaxAmount)) {
            return false;
        }
        if (!Objects.equals(this.includedNationalTaxAmount, defaultTaxDetails.includedNationalTaxAmount)) {
            return false;
        }
        return Objects.equals(this.salesSlipNumber, defaultTaxDetails.salesSlipNumber);
    }

    public int hashCode() {
        int n2 = this.merchantTaxId != null ? this.merchantTaxId.hashCode() : 0;
        n2 = 31 * n2 + (this.includedTaxAmount != null ? this.includedTaxAmount.hashCode() : 0);
        n2 = 31 * n2 + (this.includedLocalTaxAmount != null ? this.includedLocalTaxAmount.hashCode() : 0);
        n2 = 31 * n2 + (this.includedNationalTaxAmount != null ? this.includedNationalTaxAmount.hashCode() : 0);
        n2 = 31 * n2 + (this.salesSlipNumber != null ? this.salesSlipNumber.hashCode() : 0);
        return n2;
    }

    public boolean isTaxDetailsEmpty() {
        return Stream.of(this.merchantTaxId, this.includedTaxAmount, this.includedLocalTaxAmount, this.includedNationalTaxAmount, this.salesSlipNumber).allMatch(x$0 -> Objects.isNull(x$0));
    }

    public void mergeWithTaxDetails(TaxDetails taxDetails) {
        DefaultTaxDetails defaultTaxDetails = (DefaultTaxDetails)taxDetails;
        if (defaultTaxDetails.getMerchantTaxId() != null) {
            this.merchantTaxId = defaultTaxDetails.getMerchantTaxId();
        }
        if (defaultTaxDetails.getIncludedTaxAmount() != null) {
            this.includedTaxAmount = defaultTaxDetails.getIncludedTaxAmount();
        }
        if (defaultTaxDetails.getIncludedLocalTaxAmount() != null) {
            this.includedLocalTaxAmount = defaultTaxDetails.getIncludedLocalTaxAmount();
        }
        if (defaultTaxDetails.getIncludedNationalTaxAmount() != null) {
            this.includedNationalTaxAmount = defaultTaxDetails.getIncludedNationalTaxAmount();
        }
        if (defaultTaxDetails.getSalesSlipNumber() != null) {
            this.salesSlipNumber = defaultTaxDetails.getSalesSlipNumber();
        }
    }
}

