/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions;

import io.mpos.shared.transactions.AskForMotoResultConfirmation;
import io.mpos.transactions.TransactionVerificationResult;
import io.mpos.transactions.TransactionVerificationResults;
import java.util.Arrays;
import java.util.List;

public class DefaultTransactionVerificationResults
implements TransactionVerificationResults {
    private TransactionVerificationResult avsZipCodeResult;
    private TransactionVerificationResult avsStreetResult;
    private TransactionVerificationResult cvvResult;

    public DefaultTransactionVerificationResults() {
    }

    public DefaultTransactionVerificationResults(TransactionVerificationResult avsZipCodeResult, TransactionVerificationResult avsStreetResult, TransactionVerificationResult cvvResult) {
        this.avsZipCodeResult = avsZipCodeResult;
        this.avsStreetResult = avsStreetResult;
        this.cvvResult = cvvResult;
    }

    public String toString() {
        return "DefaultVerificationResultDetails{avsZipCodeResult=" + this.avsZipCodeResult + ", avsStreetResult=" + this.avsStreetResult + ", cvvResult=" + this.cvvResult + "}";
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof DefaultTransactionVerificationResults)) {
            return false;
        }
        DefaultTransactionVerificationResults defaultTransactionVerificationResults = (DefaultTransactionVerificationResults)o2;
        if (this.avsZipCodeResult != defaultTransactionVerificationResults.avsZipCodeResult) {
            return false;
        }
        if (this.avsStreetResult != defaultTransactionVerificationResults.avsStreetResult) {
            return false;
        }
        return this.cvvResult == defaultTransactionVerificationResults.cvvResult;
    }

    public int hashCode() {
        int n2 = this.avsZipCodeResult != null ? this.avsZipCodeResult.hashCode() : 0;
        n2 = 31 * n2 + (this.avsStreetResult != null ? this.avsStreetResult.hashCode() : 0);
        n2 = 31 * n2 + (this.cvvResult != null ? this.cvvResult.hashCode() : 0);
        return n2;
    }

    public TransactionVerificationResult getAvsZipCodeResult() {
        return this.avsZipCodeResult;
    }

    public void setAvsZipCodeResult(TransactionVerificationResult avsZipCodeResult) {
        this.avsZipCodeResult = avsZipCodeResult;
    }

    public TransactionVerificationResult getAvsStreetResult() {
        return this.avsStreetResult;
    }

    public void setAvsStreetResult(TransactionVerificationResult avsStreetResult) {
        this.avsStreetResult = avsStreetResult;
    }

    public TransactionVerificationResult getCvvResult() {
        return this.cvvResult;
    }

    public void setCvvResult(TransactionVerificationResult cvvResult) {
        this.cvvResult = cvvResult;
    }

    public AskForMotoResultConfirmation getCombinedMotoResult() {
        List<TransactionVerificationResult> list = Arrays.asList(this.avsStreetResult, this.avsZipCodeResult, this.cvvResult);
        if (this.isEvery(list, TransactionVerificationResult.PASSED)) {
            return AskForMotoResultConfirmation.ALL_MATCH;
        }
        if (this.avsZipCodeResult == TransactionVerificationResult.PASSED && this.avsStreetResult == TransactionVerificationResult.PASSED) {
            return AskForMotoResultConfirmation.ADDRESS_MATCH_ONLY;
        }
        if (this.cvvResult == TransactionVerificationResult.PASSED) {
            return AskForMotoResultConfirmation.CVV_MATCH_ONLY;
        }
        if (this.isAny(list, TransactionVerificationResult.NOT_PASSED)) {
            return AskForMotoResultConfirmation.NO_DATA_MATCHES;
        }
        if (this.isAny(list, TransactionVerificationResult.NOT_CHECKED)) {
            return AskForMotoResultConfirmation.DATA_NOT_CHECKED;
        }
        return AskForMotoResultConfirmation.UNKNOWN;
    }

    private boolean isEvery(List<TransactionVerificationResult> results, TransactionVerificationResult expectedResult) {
        for (TransactionVerificationResult transactionVerificationResult : results) {
            if (transactionVerificationResult == expectedResult) continue;
            return false;
        }
        return true;
    }

    private boolean isAny(List<TransactionVerificationResult> results, TransactionVerificationResult expectedResult) {
        for (TransactionVerificationResult transactionVerificationResult : results) {
            if (transactionVerificationResult != expectedResult) continue;
            return true;
        }
        return false;
    }
}

