/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions.actionresponse;

import io.mpos.paymentdetails.ApplicationInformation;
import io.mpos.paymentdetails.InteracAccountType;
import io.mpos.shared.transactions.actionresponse.TransactionActionApplicationSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionCreditDebitSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionCustomerIdentificationResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionCustomerSignatureResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionDccSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionInteracAccountSelectionResponse;
import io.mpos.shared.transactions.actionresponse.TransactionActionLanguageSelectionResponse;
import io.mpos.transactions.actionresponse.TransactionActionResponse;
import io.mpos.transactions.actionresponse.TransactionActionResponseFactory;
import java.util.Locale;

public class DefaultTransactionActionResponseDataFactory
implements TransactionActionResponseFactory {
    @Override
    public TransactionActionResponse createResponseForSignatureAction(byte[] signature, boolean verified) {
        return new TransactionActionCustomerSignatureResponse(signature, verified, false, false);
    }

    @Override
    public TransactionActionResponse createResponseForSignatureOnReceiptAction() {
        return new TransactionActionCustomerSignatureResponse(null, true, true, false);
    }

    @Override
    public TransactionActionResponse createResponseForSignatureSkippedAction() {
        return new TransactionActionCustomerSignatureResponse(null, true, false, true);
    }

    @Override
    public TransactionActionResponse createResponseForIdentificationAction(boolean verified) {
        return new TransactionActionCustomerIdentificationResponse(verified);
    }

    @Override
    public TransactionActionResponse createResponseForApplicationSelection(ApplicationInformation selectedApplication) {
        return new TransactionActionApplicationSelectionResponse(selectedApplication);
    }

    @Override
    public TransactionActionResponse createResponseForCreditDebitSelectionWithCredit() {
        return new TransactionActionCreditDebitSelectionResponse(TransactionActionCreditDebitSelectionResponse.Type.CREDIT);
    }

    @Override
    public TransactionActionResponse createResponseForCreditDebitSelectionWithDebit() {
        return new TransactionActionCreditDebitSelectionResponse(TransactionActionCreditDebitSelectionResponse.Type.DEBIT);
    }

    @Override
    public TransactionActionResponse createResponseForDccSelectionOriginal() {
        return new TransactionActionDccSelectionResponse(TransactionActionDccSelectionResponse.Selected.ORIGINAL);
    }

    @Override
    public TransactionActionResponse createResponseForDccSelectionConverted() {
        return new TransactionActionDccSelectionResponse(TransactionActionDccSelectionResponse.Selected.CONVERTED);
    }

    @Override
    public TransactionActionResponse createResponseForInteracAccountChecking() {
        return new TransactionActionInteracAccountSelectionResponse(InteracAccountType.CHECKING);
    }

    @Override
    public TransactionActionResponse createResponseForInteracAccountSaving() {
        return new TransactionActionInteracAccountSelectionResponse(InteracAccountType.SAVINGS);
    }

    @Override
    public TransactionActionResponse createResponseForLanguageSelection(Locale language) {
        return new TransactionActionLanguageSelectionResponse(language);
    }
}

