/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.transactions.helper;

import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactions.RefundDetailsProcess;
import io.mpos.transactions.RefundDetailsStatus;
import io.mpos.transactions.TransactionType;
import java.util.EnumSet;

public class TransactionInspector {
    private BaseTransaction mTransaction;

    public TransactionInspector(BaseTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("transaction cannot be null");
        }
        this.mTransaction = transaction;
    }

    public boolean isRefundable() {
        if (this.mTransaction.getType() == TransactionType.CHARGE) {
            RefundDetailsStatus refundDetailsStatus = this.mTransaction.getRefundDetails().getStatus();
            return refundDetailsStatus == RefundDetailsStatus.REFUNDABLE_PARTIAL_AND_FULL || refundDetailsStatus == RefundDetailsStatus.REFUNDABLE_FULL_ONLY;
        }
        return false;
    }

    public boolean isRefundableWithCard() {
        if (this.mTransaction.getType() == TransactionType.CHARGE) {
            EnumSet enumSet = this.mTransaction.getRefundDetails().getProcess();
            return enumSet.contains(RefundDetailsProcess.ANY_CARD) || enumSet.contains(RefundDetailsProcess.SAME_CARD);
        }
        return false;
    }

    public boolean isRefundableWithoutCard() {
        if (this.mTransaction.getType() == TransactionType.CHARGE) {
            return this.mTransaction.getRefundDetails().getProcess().contains(RefundDetailsProcess.WITHOUT_CARD);
        }
        return false;
    }
}

