/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.util;

import io.mpos.core.common.obfuscated.cw;
import io.mpos.logger.Log;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.emv.TagTerminalVerificationResults;
import java.util.EnumSet;

public class TagUtils {
    private static final String TAG = "TagUtils";

    public static boolean isPinBypassed(PrimitiveTlv primitiveTlv) {
        return TagUtils.tvrContains(primitiveTlv, cw.u);
    }

    public static boolean isPinTryLimitExceeded(PrimitiveTlv primitiveTlv) {
        return TagUtils.tvrContains(primitiveTlv, cw.s);
    }

    private static boolean tvrContains(PrimitiveTlv primitiveTlv, cw tvrToCheck) {
        if (primitiveTlv == null) {
            Log.w(TAG, "PrimitiveTlv for ARQC cannot be null");
            return false;
        }
        TagTerminalVerificationResults tagTerminalVerificationResults = TagTerminalVerificationResults.wrap(primitiveTlv);
        EnumSet<cw> enumSet = cw.a(tagTerminalVerificationResults.getValue());
        if (enumSet == null) {
            Log.w(TAG, "Cannot calculate terminal verification results for provided ARQC");
            return false;
        }
        return enumSet.contains((Object)tvrToCheck);
    }
}

