/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.validator;

import io.mpos.shared.validator.ValidationError;
import java.util.ArrayList;
import java.util.List;

public class ValidationResult {
    private boolean success = true;
    private List<ValidationError> errors = new ArrayList<ValidationError>();

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ValidationError> errors) {
        this.errors = errors;
    }

    public void addError(ValidationError error) {
        this.errors.add(error);
    }

    public String getErrorInfoConcat() {
        StringBuilder stringBuilder = new StringBuilder();
        for (ValidationError validationError : this.errors) {
            stringBuilder.append(validationError.getErrorInfo());
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ValidationResult validationResult = (ValidationResult)o2;
        if (this.success != validationResult.success) {
            return false;
        }
        return this.errors != null ? this.errors.equals(validationResult.errors) : validationResult.errors == null;
    }

    public int hashCode() {
        int n2 = this.success ? 1 : 0;
        n2 = 31 * n2 + (this.errors != null ? this.errors.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "ValidationResult{success=" + this.success + ", errors=" + this.errors + "}";
    }
}

