/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.shared.workflows.evaluator;

import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.workflows.evaluator.LanguageEvaluationResult;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\bH\u0002J&\u0010\u0013\u001a\u0004\u0018\u00010\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u0015"}, d2={"Lio/mpos/shared/workflows/evaluator/LanguageEvaluator;", "", "<init>", "()V", "evaluate", "Lio/mpos/shared/workflows/evaluator/LanguageEvaluationResult;", "cardLanguages", "", "Ljava/util/Locale;", "terminalLanguages", "merchantPreference", "behaviors", "Ljava/util/EnumSet;", "Lio/mpos/shared/provider/ProcessingOptions$Behavior;", "preferUseOfMerchantLanguage", "", "cardSupportsMerchantLanguage", "languages", "locale", "supportedWithHighestPreference", "supportedLanguages", "mpos.core"})
@SourceDebugExtension(value={"SMAP\nLanguageEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageEvaluator.kt\nio/mpos/shared/workflows/evaluator/LanguageEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n1761#2,3:41\n*S KotlinDebug\n*F\n+ 1 LanguageEvaluator.kt\nio/mpos/shared/workflows/evaluator/LanguageEvaluator\n*L\n25#1:41,3\n*E\n"})
public final class LanguageEvaluator {
    @NotNull
    public static final LanguageEvaluator INSTANCE = new LanguageEvaluator();

    private LanguageEvaluator() {
    }

    @JvmStatic
    @NotNull
    public static final LanguageEvaluationResult evaluate(@NotNull List<Locale> cardLanguages, @NotNull List<Locale> terminalLanguages, @NotNull Locale merchantPreference, @NotNull EnumSet<ProcessingOptions.Behavior> behaviors) {
        Intrinsics.checkNotNullParameter(cardLanguages, (String)"");
        Intrinsics.checkNotNullParameter(terminalLanguages, (String)"");
        Intrinsics.checkNotNullParameter((Object)merchantPreference, (String)"");
        Intrinsics.checkNotNullParameter(behaviors, (String)"");
        return new LanguageEvaluationResult(INSTANCE.preferUseOfMerchantLanguage(behaviors) && INSTANCE.cardSupportsMerchantLanguage(cardLanguages, merchantPreference) ? merchantPreference : INSTANCE.supportedWithHighestPreference(cardLanguages, terminalLanguages));
    }

    private final boolean preferUseOfMerchantLanguage(EnumSet<ProcessingOptions.Behavior> behaviors) {
        return behaviors.contains((Object)ProcessingOptions.Behavior.PREFER_MERCHANT_LANGUAGE_FOR_ACCESSORY_PROMPTS);
    }

    private final boolean cardSupportsMerchantLanguage(List<Locale> languages, Locale locale) {
        boolean bl2;
        block3: {
            Iterable iterable = languages;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl2 = false;
            } else {
                for (Object t2 : iterable) {
                    Locale locale2 = (Locale)t2;
                    if (!Intrinsics.areEqual((Object)locale2.getLanguage(), (Object)locale.getLanguage())) continue;
                    bl2 = true;
                    break block3;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private final Locale supportedWithHighestPreference(List<Locale> languages, List<Locale> supportedLanguages) {
        for (Locale locale : languages) {
            Locale locale2 = LocalizationServer.getSupportedLocale(locale, supportedLanguages);
            if (locale2 == null) continue;
            return locale2;
        }
        return null;
    }
}

