/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv;

import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PrimitiveTlv
extends TlvObject {
    protected byte[] value = null;

    public PrimitiveTlv(byte cla, int tag, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null.");
        }
        if (cla > 3) {
            throw new IllegalArgumentException("CLA must be 0x00, 0x01, 0x02 or 0x03.");
        }
        this.tagBytes = super.buildTagBytes(cla, tag);
        this.value = value;
    }

    public PrimitiveTlv(byte[] tagBytes, byte[] value) {
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null.");
        }
        if (tagBytes == null) {
            throw new IllegalArgumentException("The tagBytes must not be null.");
        }
        if (tagBytes.length < 1) {
            throw new IllegalArgumentException("The tagBytes must have length >= 1.");
        }
        this.tagBytes = tagBytes;
        this.value = value;
    }

    @Override
    public byte[] serialize() {
        if (this.cacheSerialization != null) {
            return this.cacheSerialization;
        }
        byte[] byArray = super.buildLenBytes(this.value.length);
        int n2 = this.tagBytes.length + byArray.length + this.value.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        byteBuffer.put(this.tagBytes);
        byteBuffer.put(byArray);
        byteBuffer.put(this.value);
        this.cacheSerialization = byteBuffer.array();
        return this.cacheSerialization;
    }

    static TlvObject deserialize(byte[] tagBytes, int len, ByteBuffer buffer) {
        byte[] byArray = new byte[len];
        buffer.get(byArray);
        return new PrimitiveTlv(tagBytes, byArray);
    }

    @Override
    protected int getLen() {
        return this.value.length;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        PrimitiveTlv primitiveTlv = (PrimitiveTlv)o2;
        return Arrays.equals(this.value, primitiveTlv.value);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.value != null ? Arrays.hashCode(this.value) : 0);
        return n2;
    }

    @Override
    public String toString() {
        return "PrimitiveTlv{tagBytes=" + ByteHelper.toHexString(this.getTagBytes()) + (String)(this.cacheSerialization != null ? ", cacheSerialization=" + ByteHelper.toHexString(this.cacheSerialization) : "") + "}";
    }
}

