/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv.mapped;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public abstract class AbstractMappedPrimitiveTlv
extends PrimitiveTlv {
    public static final int DATA_TYPE_UNKNOWN_OR_UNDEFINED = 0;
    public static final int DATA_TYPE_ALPHABETIC = 1;
    public static final int DATA_TYPE_ALPHANUMERIC = 2;
    public static final int DATA_TYPE_ALPHANUMERIC_SPECIAL = 3;
    public static final int DATA_TYPE_ALPHANUMERIC_ISO_LATIN1 = 4;
    public static final int DATA_TYPE_BINARY = 16;
    public static final int DATA_TYPE_BINARY_NUMERIC = 17;
    public static final int DATA_TYPE_BINARY_HEX = 18;
    public static final int DATA_TYPE_NUMERIC = 32;
    public static final int DATA_TYPE_NUMERIC_COMPRESSED = 33;
    public static final int DATA_TYPE_VARIABLE = 48;
    protected int dataType = 0;

    @Deprecated
    protected AbstractMappedPrimitiveTlv(byte cla, int tag, byte[] value) {
        super(cla, tag, value);
    }

    protected AbstractMappedPrimitiveTlv(byte[] tagBytes, byte[] value) {
        super(tagBytes, value);
    }

    @Override
    public String toString() {
        Object object;
        try {
            object = ", string representation: " + this.internalToString(this.getDataType());
        }
        catch (Exception exception) {
            object = ", no string representation possible";
        }
        return "AbstractMappedPrimitiveTlv{" + this.getDescription() + ", tagBytes=" + ByteHelper.toHexString(this.getTagBytes()) + ", dataType=" + this.dataType + (String)object + (String)(this.cacheSerialization != null ? ", cacheSerialization=" + ByteHelper.toHexString(this.cacheSerialization) : "") + "}";
    }

    public String getValueAsString() {
        return this.internalToString(this.getDataType());
    }

    protected String internalToString(int dataType) {
        String string;
        if (this.getValue() == null) {
            return null;
        }
        if (this.getValue().length == 0) {
            return "";
        }
        switch (dataType) {
            case 1: {
                string = EnDecodeHelper.fromAscii(this.getValue());
                string = EnDecodeHelper.removeAllExceptAlphabetic(string);
                break;
            }
            case 2: {
                string = EnDecodeHelper.fromAscii(this.getValue());
                string = EnDecodeHelper.removeAllExceptAlphanumeric(string);
                break;
            }
            case 4: {
                string = EnDecodeHelper.fromISOLatin1(this.getValue());
                break;
            }
            case 3: {
                string = EnDecodeHelper.fromAscii(this.getValue());
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 48: {
                string = ByteHelper.toHexShortString(this.getValue());
                break;
            }
            case 33: {
                string = EnDecodeHelper.fromHex(this.getValue());
                string = EnDecodeHelper.removeTrailingFs(string);
                break;
            }
            case 32: {
                string = EnDecodeHelper.fromHex(this.getValue());
                string = EnDecodeHelper.removeLeadingZeros(string);
                string = EnDecodeHelper.removeAllExceptNumeric(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle dataType: " + dataType);
            }
        }
        return string;
    }

    public abstract String getDescription();

    public int getDataType() {
        return this.dataType;
    }
}

