/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.bertlv.mapped;

import io.mpos.specs.bertlv.mapped.AbstractMappedPrimitiveTlv;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.Arrays;

public abstract class MappedNumericTlv
extends AbstractMappedPrimitiveTlv {
    protected MappedNumericTlv(byte cla, int tag, byte[] value) {
        super(cla, tag, value);
        this.dataType = 32;
    }

    protected MappedNumericTlv(byte[] tagBytes, byte[] value) {
        super(tagBytes, value);
        this.dataType = 32;
    }

    protected static byte[] encodeValueFixedLength(String data, int len) {
        byte[] byArray = new byte[len];
        Arrays.fill(byArray, (byte)0);
        byte[] byArray2 = EnDecodeHelper.toHex(data);
        if (byArray2.length > byArray.length) {
            throw new IllegalArgumentException("The length of the data must not be larger than 'len'.");
        }
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        return byArray;
    }

    public long decodeValue() {
        return EnDecodeHelper.decodeBCD(this.getValue());
    }
}

