/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagAmountAuthorized
extends MappedNumericTlv {
    public static int TAG = 40706;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 6;

    private TagAmountAuthorized(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Authorised amount of the transaction (excluding adjustments)";
    }

    public static TagAmountAuthorized create(String amount) {
        amount = EnDecodeHelper.removeAllExceptNumeric(amount);
        byte[] byArray = MappedNumericTlv.encodeValueFixedLength(amount, FIXED_LENGTH);
        return new TagAmountAuthorized(byArray);
    }

    public static TagAmountAuthorized wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagAmountAuthorized(tlv.getValue());
    }
}

