/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagApplicationCurrencyCode
extends MappedNumericTlv {
    public static final int TAG = 40770;
    public static final byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(40770);
    public static final int FIXED_LENGTH = 2;

    private TagApplicationCurrencyCode(byte[] currencyIsoCode) {
        super(TAG_BYTES, currencyIsoCode);
    }

    @Override
    public String getDescription() {
        return "Indicates the currency in which the account is managed according to ISO 4217";
    }

    public static TagApplicationCurrencyCode wrap(PrimitiveTlv primitiveTlv) {
        if (!primitiveTlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (primitiveTlv.getValue().length != 2) {
            throw new IllegalArgumentException("The value must have a length of: 2");
        }
        return new TagApplicationCurrencyCode(primitiveTlv.getValue());
    }
}

