/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.shared.helper.TimeHelper;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.Date;

public class TagApplicationExpiryDate
extends MappedNumericTlv {
    public static int TAG = 24356;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 3;

    private TagApplicationExpiryDate(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Date after which application expires";
    }

    public static TagApplicationExpiryDate create(Date date) {
        return TagApplicationExpiryDate.create(TimeHelper.createDateTimeFormat((String)"yyMMdd").format(date));
    }

    public static TagApplicationExpiryDate create(String date) {
        if (date.length() != 6) {
            throw new IllegalArgumentException("The date string must have a length of 6");
        }
        return new TagApplicationExpiryDate(EnDecodeHelper.toHex(date));
    }

    public static TagApplicationExpiryDate wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagApplicationExpiryDate(tlv.getValue());
    }

    public String getExpiryDate() {
        return String.format("%02d", this.getYY()) + String.format("%02d", this.getMM()) + String.format("%02d", this.getDD());
    }

    public int getYY() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[0]});
    }

    public int getMM() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[1]});
    }

    public int getDD() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[2]});
    }
}

