/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.GregorianCalendar;

public class TagApplicationExpiryDateCartesBancaires
extends MappedNumericTlv {
    public static int TAG = 24356;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 2;

    private TagApplicationExpiryDateCartesBancaires(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Date after which application expires, specific for some CB test cards";
    }

    public static TagApplicationExpiryDateCartesBancaires create(String date) {
        if (date == null) {
            throw new IllegalArgumentException("The date string must not be null");
        }
        if (date.length() != 4) {
            throw new IllegalArgumentException("The date string must have a length of 4");
        }
        byte[] byArray = EnDecodeHelper.toHex(date);
        if (byArray.length != 2) {
            throw new IllegalArgumentException("The date string contains invalid chars");
        }
        return new TagApplicationExpiryDateCartesBancaires(byArray);
    }

    public static TagApplicationExpiryDateCartesBancaires wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagApplicationExpiryDateCartesBancaires(tlv.getValue());
    }

    public String getOriginalExpiryDate() {
        return String.format("%02d%02d", this.getYY(), this.getMM());
    }

    public String getExtendedExpiryDate() {
        return String.format("%02d%02d%02d", this.getYY(), this.getMM(), this.getDD());
    }

    public int getYY() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[0]});
    }

    public int getMM() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[1]});
    }

    public int getDD() {
        return this.lastDayOfMonth();
    }

    public int lastDayOfMonth() {
        int n2 = this.getYY();
        int n3 = this.getMM();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n2, n3 - 1, 1);
        int n4 = gregorianCalendar.getActualMaximum(5);
        return n4;
    }
}

