/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphanumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagApplicationPreferredLanguages
extends MappedAlphanumericTlv {
    public static int TAG = 24365;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    private TagApplicationPreferredLanguages(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates application preferred languages list in combined string of 2 letter language codes aligned with ISO 639";
    }

    public static TagApplicationPreferredLanguages create(byte[] preferredLanguages) {
        return new TagApplicationPreferredLanguages(preferredLanguages);
    }

    public static TagApplicationPreferredLanguages wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of=" + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagApplicationPreferredLanguages.create(tlv.getValue());
    }
}

