/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedCompressedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagApplicationPrimaryAccountNumber
extends MappedCompressedNumericTlv {
    public static int TAG = 90;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    private TagApplicationPrimaryAccountNumber(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Valid cardholder account number";
    }

    public static TagApplicationPrimaryAccountNumber create(String cardSequenceNumber) {
        cardSequenceNumber = EnDecodeHelper.removeAllExceptNumeric(cardSequenceNumber);
        byte[] byArray = MappedCompressedNumericTlv.encodeValueVariableLength(cardSequenceNumber);
        return new TagApplicationPrimaryAccountNumber(byArray);
    }

    public static TagApplicationPrimaryAccountNumber wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return new TagApplicationPrimaryAccountNumber(tlv.getValue());
    }
}

