/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagCardTransactionInformation
extends MappedBinaryTlv {
    public static int TAG = 40803;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int LENGTH = 4;

    private TagCardTransactionInformation(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Card Transaction Information";
    }

    public static TagCardTransactionInformation wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tlv object must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagCardTransactionInformation.create(tlv.getValue());
    }

    public static TagCardTransactionInformation create(byte[] tag) {
        if (tag.length != LENGTH) {
            throw new IllegalArgumentException("The card transaction information must be exactly 4 bytes long.");
        }
        return new TagCardTransactionInformation(tag);
    }

    public boolean isContactlessPerTransactionLimitExceeded() {
        return (this.value[1] & 1) == 1;
    }
}

