/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedAlphanumericSpecialTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagCardholderNameExtended
extends MappedAlphanumericSpecialTlv {
    public static int TAG = 40715;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MIN_LENGTH = 27;
    public static int MAX_LENGTH = 45;

    private TagCardholderNameExtended(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates the whole cardholder name when greater than 26 characters using the same coding convention as in ISO 7813";
    }

    public static TagCardholderNameExtended create(byte[] name) {
        if (name.length < MIN_LENGTH) {
            throw new IllegalArgumentException("The name must be at least 5 bytes long.");
        }
        if (name.length > MAX_LENGTH) {
            throw new IllegalArgumentException("The name must not be longer than 16 bytes.");
        }
        return new TagCardholderNameExtended(name);
    }

    public static TagCardholderNameExtended wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagCardholderNameExtended.create(tlv.getValue());
    }
}

