/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagCardholderVerificationMethodResults
extends MappedBinaryTlv {
    public static int TAG = 40756;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int LENGTH = 3;
    public static final byte MP_CVM_REMOVE_FAIL_OR_SUCCEEDING_RULE = -65;
    public static final byte MP_CVM_NOT_PERFORMED = 63;
    public static final byte MP_CVM_SIGNATURE = 30;
    public static final byte MP_CVM_PLAINTEXT_OFFLINE_PIN_AND_SIGNATURE = 3;
    public static final byte MP_CVM_ENCIPHERED_OFFLINE_PIN_AND_SIGNATURE = 5;
    public static final byte MP_CVM_PLAINTEXT_OFFLINE_PIN = 1;
    public static final byte MP_CVM_ENCIPHERED_ONLINE_PIN = 2;
    public static final byte MP_CVM_ENCIPHERED_OFFLINE_PIN = 4;
    public static final byte MP_CVM_NO_CMV = 31;
    public static final byte MP_CVM_FAIL = 0;

    private TagCardholderVerificationMethodResults(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Cardholder verification tag";
    }

    public static TagCardholderVerificationMethodResults create(byte[] cvm) {
        if (cvm.length != LENGTH) {
            throw new IllegalArgumentException("The cardholder verification must be exactly 3 bytes long.");
        }
        return new TagCardholderVerificationMethodResults(cvm);
    }

    public static TagCardholderVerificationMethodResults wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagCardholderVerificationMethodResults.create(tlv.getValue());
    }
}

