/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedBinaryTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagDedicatedFileName
extends MappedBinaryTlv {
    public static int TAG = 132;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    private TagDedicatedFileName(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Identifies the name of the DF as described in ISO/IEC 7816-4";
    }

    public static TagDedicatedFileName create(byte[] dfn) {
        return new TagDedicatedFileName(dfn);
    }

    public static TagDedicatedFileName wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagDedicatedFileName.create(tlv.getValue());
    }
}

