/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.bertlv.mapped.AbstractMappedConstructedTlv;
import io.mpos.specs.helper.ByteHelper;
import java.util.ArrayList;

public class TagFileControlInformationTemplate
extends AbstractMappedConstructedTlv {
    public static int TAG = 111;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    public TagFileControlInformationTemplate() {
        super(TAG_BYTES);
    }

    private TagFileControlInformationTemplate(ArrayList<TlvObject> items) {
        super(TAG_BYTES);
        this.items = items;
    }

    @Override
    public String getDescription() {
        return "Identifies the FCI template according to ISO/IEC 7816-4";
    }

    public static TagFileControlInformationTemplate create(ArrayList<TlvObject> items) {
        if (items == null) {
            throw new IllegalArgumentException("'items' must not be null.");
        }
        return new TagFileControlInformationTemplate(items);
    }

    public static TagFileControlInformationTemplate wrap(ConstructedTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagFileControlInformationTemplate.create(tlv.getItems());
    }
}

