/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagIssuerCodeTableIndex
extends MappedNumericTlv {
    public static int TAG = 40721;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static final String LATIN1_CODE_TABLE_INDEX = "1";

    protected TagIssuerCodeTableIndex(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Index of table used to decode a string into ISO-8859";
    }

    public static TagIssuerCodeTableIndex wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return new TagIssuerCodeTableIndex(tlv.getValue());
    }
}

