/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagIssuerCountryCode
extends MappedNumericTlv {
    public static final int TAG = 24360;
    public static final byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(24360);
    public static final int FIXED_LENGTH = 2;

    private TagIssuerCountryCode(byte[] var1) {
        super(TAG_BYTES, var1);
    }

    @Override
    public String getDescription() {
        return "Indicates the country code of the transaction according to ISO 4217";
    }

    public static TagIssuerCountryCode wrap(PrimitiveTlv primitiveTlv) {
        if (!primitiveTlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (primitiveTlv.getValue().length != 2) {
            throw new IllegalArgumentException("The value must have a length of: 2");
        }
        return new TagIssuerCountryCode(primitiveTlv.getValue());
    }
}

