/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.bertlv.mapped.AbstractMappedConstructedTlv;
import io.mpos.specs.helper.ByteHelper;
import java.util.ArrayList;

public class TagIssuerScriptTemplate2
extends AbstractMappedConstructedTlv {
    public static int TAG = 114;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);

    private TagIssuerScriptTemplate2() {
        super(TAG_BYTES);
    }

    private TagIssuerScriptTemplate2(ArrayList<TlvObject> items) {
        super(TAG_BYTES);
        this.items = items;
    }

    @Override
    public String getDescription() {
        return "Contains proprietary issuer data for transmission to the ICC after the second GENERATE AC command";
    }

    public static TagIssuerScriptTemplate2 create(ArrayList<TlvObject> items) {
        if (items == null) {
            throw new IllegalArgumentException("'items' must not be null.");
        }
        return new TagIssuerScriptTemplate2(items);
    }

    public static TagIssuerScriptTemplate2 wrap(ConstructedTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        return TagIssuerScriptTemplate2.create(tlv.getItems());
    }
}

