/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedCompressedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;

public class TagPAN
extends MappedCompressedNumericTlv {
    public static int TAG = 90;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int MAX_LENGTH_DIGITS = 19;
    public static int MAX_LENGTH_BYTES = (MAX_LENGTH_DIGITS + 1) / 2;

    private TagPAN(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Application Primary Account Number (PAN); Valid cardholder account number";
    }

    public static TagPAN create(String pan) {
        if ((pan = EnDecodeHelper.removeAllExceptNumeric(pan)).length() > MAX_LENGTH_DIGITS) {
            throw new IllegalArgumentException("The pan must not be longer than 19 digits.");
        }
        byte[] byArray = MappedCompressedNumericTlv.encodeValueVariableLength(pan);
        return new TagPAN(byArray);
    }

    public static TagPAN wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length > MAX_LENGTH_BYTES) {
            throw new IllegalArgumentException("The value must not be larger than : " + MAX_LENGTH_BYTES);
        }
        return new TagPAN(tlv.getValue());
    }
}

