/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagTransactionCurrencyCode
extends MappedNumericTlv {
    public static int TAG = 24362;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 2;

    private TagTransactionCurrencyCode(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates the currency code of the transaction according to ISO 4217";
    }

    public static TagTransactionCurrencyCode create(String currencyCode) {
        byte[] byArray = MappedNumericTlv.encodeValueFixedLength(currencyCode, FIXED_LENGTH);
        return new TagTransactionCurrencyCode(byArray);
    }

    public static TagTransactionCurrencyCode wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagTransactionCurrencyCode(tlv.getValue());
    }
}

