/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;

public class TagTransactionCurrencyExponent
extends MappedNumericTlv {
    public static int TAG = 24374;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH_BYTES = 1;
    public static int FIXED_LENGTH_DIGITS = 1;

    private TagTransactionCurrencyExponent(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Indicates the implied position of the decimal point from the right of the transaction amount represented according to ISO 4217";
    }

    public static TagTransactionCurrencyExponent create(String currencyExponent) {
        if (currencyExponent.length() > FIXED_LENGTH_DIGITS) {
            throw new IllegalArgumentException("Only one digit allowed in currencyExponent");
        }
        byte[] byArray = MappedNumericTlv.encodeValueFixedLength(currencyExponent, FIXED_LENGTH_BYTES);
        return new TagTransactionCurrencyExponent(byArray);
    }

    public static TagTransactionCurrencyExponent wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH_BYTES) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH_BYTES);
        }
        return new TagTransactionCurrencyExponent(tlv.getValue());
    }
}

