/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.shared.helper.TimeHelper;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.Date;

public class TagTransactionDate
extends MappedNumericTlv {
    public static int TAG = 154;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 3;

    private TagTransactionDate(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Local date that the transaction was authorised";
    }

    public static TagTransactionDate create(Date date) {
        return TagTransactionDate.create(TimeHelper.createDateTimeFormat((String)"yyMMdd").format(date));
    }

    public static TagTransactionDate create(String date) {
        if (date.length() != 6) {
            throw new IllegalArgumentException("The date string must have a length of 6");
        }
        return new TagTransactionDate(EnDecodeHelper.toHex(date));
    }

    public static TagTransactionDate wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagTransactionDate(tlv.getValue());
    }

    public int getYY() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[0]});
    }

    public int getMM() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[1]});
    }

    public int getDD() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[2]});
    }
}

