/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.emv;

import io.mpos.shared.helper.TimeHelper;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.mapped.MappedNumericTlv;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.Date;

public class TagTransactionTime
extends MappedNumericTlv {
    public static int TAG = 40737;
    public static byte[] TAG_BYTES = ByteHelper.intToStrippedByteArray(TAG);
    public static int FIXED_LENGTH = 3;

    private TagTransactionTime(byte[] value) {
        super(TAG_BYTES, value);
    }

    @Override
    public String getDescription() {
        return "Local time that the transaction was authorised";
    }

    public static TagTransactionTime create(Date date) {
        return TagTransactionTime.create(TimeHelper.createDateTimeFormat((String)"HHmmss").format(date));
    }

    public static TagTransactionTime create(String date) {
        if (date.length() != 6) {
            throw new IllegalArgumentException("The time string must have a length of 6");
        }
        return new TagTransactionTime(EnDecodeHelper.toHex(date));
    }

    public static TagTransactionTime wrap(PrimitiveTlv tlv) {
        if (!tlv.hasThisTag(TAG_BYTES)) {
            throw new IllegalArgumentException("The tag must have the tag of: " + ByteHelper.toHexString(TAG_BYTES));
        }
        if (tlv.getValue().length != FIXED_LENGTH) {
            throw new IllegalArgumentException("The value must have a length of: " + FIXED_LENGTH);
        }
        return new TagTransactionTime(tlv.getValue());
    }

    public int getHH() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[0]});
    }

    public int getMM() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[1]});
    }

    public int getSS() {
        return (int)EnDecodeHelper.decodeBCD(new byte[]{this.value[2]});
    }
}

