/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.specs.helper.ByteHelper;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EnDecodeHelper {
    private static final Pattern REGEX_NOT_ALPHABETIC = Pattern.compile("[^a-zA-Z]");
    private static final Pattern REGEX_NOT_ALPHANUMERIC = Pattern.compile("[^a-zA-Z0-9]");
    private static final Pattern REGEX_NOT_NUMERIC = Pattern.compile("[^0-9]");
    private static final Pattern REGEX_TRAILING_FS = Pattern.compile("[fF]*$");
    private static final Pattern REGEX_LEADING_ZEROS = Pattern.compile("^0*");

    public static String fromAscii(byte[] arr) {
        try {
            return new String(arr, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't decode array as 'US-ASCII'.", unsupportedEncodingException);
        }
    }

    public static byte[] toAscii(String s2) {
        try {
            return s2.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't encode string as 'US-ASCII'.", unsupportedEncodingException);
        }
    }

    public static byte[] toUtf8(String s2) {
        try {
            return s2.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't encode string as 'UTF-8'.", unsupportedEncodingException);
        }
    }

    public static byte[] toISOLatin1(String s2) {
        try {
            return s2.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't encode string as 'ISO-8850-1'.", unsupportedEncodingException);
        }
    }

    public static String fromISOLatin1(byte[] arr) {
        try {
            return new String(arr, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't decode array as 'ISO-8850-1'.", unsupportedEncodingException);
        }
    }

    public static String fromHex(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException("The array must not be null.");
        }
        return ByteHelper.toHexShortString(arr);
    }

    public static String fromUtf8(byte[] arr) {
        try {
            return new String(arr, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't decode array as 'UTF-8'.", unsupportedEncodingException);
        }
    }

    public static String fromUtf16Unicode(byte[] arr) {
        try {
            return new String(arr, "UTF-16");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't decode array as 'UTF-16'.", unsupportedEncodingException);
        }
    }

    public static byte[] toHex(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("The string must not be null.");
        }
        return ByteHelper.fromHexString(s2);
    }

    public static long decodeBCD(byte[] arr) {
        if (arr == null) {
            throw new IllegalArgumentException("The array must not be null.");
        }
        String string = EnDecodeHelper.fromHex(arr);
        return Long.parseLong(string, 10);
    }

    public static byte[] toWindowsCP1252(String s2) {
        try {
            return s2.getBytes("CP1252");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Couldn't encode string as 'CP1252'.", unsupportedEncodingException);
        }
    }

    public static String removeAllExceptAlphabetic(String s2) {
        Matcher matcher = REGEX_NOT_ALPHABETIC.matcher(s2);
        return matcher.replaceAll("");
    }

    public static String removeAllExceptAlphanumeric(String s2) {
        Matcher matcher = REGEX_NOT_ALPHANUMERIC.matcher(s2);
        return matcher.replaceAll("");
    }

    public static String removeAllExceptNumeric(String s2) {
        Matcher matcher = REGEX_NOT_NUMERIC.matcher(s2);
        return matcher.replaceAll("");
    }

    public static String removeTrailingFs(String s2) {
        Matcher matcher = REGEX_TRAILING_FS.matcher(s2);
        return matcher.replaceAll("");
    }

    public static String removeLeadingZeros(String s2) {
        if (s2 == null || s2.length() == 0) {
            return "";
        }
        Matcher matcher = REGEX_LEADING_ZEROS.matcher(s2);
        String string = matcher.replaceAll("");
        if (string.length() == 0) {
            string = "0";
        }
        return string;
    }
}

