/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.logger.Log;
import io.mpos.shared.paymentdetails.IccInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsIccWrapper;
import io.mpos.shared.provider.CardHelper;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TLVHelper;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.bertlv.mapped.AbstractMappedPrimitiveTlv;
import io.mpos.specs.emv.TagApplicationExpiryDate;
import io.mpos.specs.emv.TagApplicationExpiryDateCartesBancaires;
import io.mpos.specs.emv.TagApplicationIdentifier;
import io.mpos.specs.emv.TagApplicationLabelISOLatin1;
import io.mpos.specs.emv.TagApplicationPrimaryAccountNumber;
import io.mpos.specs.emv.TagApplicationPrimaryAccountNumberSequenceNumber;
import io.mpos.specs.emv.TagCardholderName;
import io.mpos.specs.emv.TagCardholderNameExtended;
import io.mpos.specs.emv.TagCryptogramInformationData;
import io.mpos.specs.emv.TagDedicatedFileName;
import io.mpos.specs.emv.TagIssuerCodeTableIndex;
import io.mpos.specs.emv.TagPreferredApplicationNameISOLatin1;
import io.mpos.specs.emv.TagTrack2EquivalentData;
import io.mpos.specs.helper.cid.ApplicationCryptogramType;
import io.mpos.specs.helper.cid.CryptogramInformationData;
import java.util.Arrays;
import java.util.List;

public class GenericEmvExtractor {
    private static final String TAG = "GenericEmvExtractor";

    public static void extractGenericDataToIccWrapper(PaymentDetailsIccWrapper iccWrapper, List<TlvObject> iccData) {
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagDedicatedFileName.TAG_BYTES, iccData);
        PrimitiveTlv primitiveTlv2 = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationIdentifier.TAG_BYTES, iccData);
        PrimitiveTlv primitiveTlv3 = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationLabelISOLatin1.TAG_BYTES, iccData);
        PrimitiveTlv primitiveTlv4 = TLVHelper.findFirstPrimitiveItemInArray(TagPreferredApplicationNameISOLatin1.TAG_BYTES, iccData);
        PrimitiveTlv primitiveTlv5 = TLVHelper.findFirstPrimitiveItemInArray(TagIssuerCodeTableIndex.TAG_BYTES, iccData);
        byte[] byArray = null;
        if (TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv)) {
            byArray = primitiveTlv.getValue();
        } else if (TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv2)) {
            byArray = primitiveTlv2.getValue();
        }
        String string = null;
        if (TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv4) && TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv5) && "1".equalsIgnoreCase(TagIssuerCodeTableIndex.wrap(primitiveTlv5).getValueAsString())) {
            string = TagPreferredApplicationNameISOLatin1.wrap(primitiveTlv4).getValueAsString();
        } else if (TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv3)) {
            string = TagApplicationLabelISOLatin1.wrap(primitiveTlv3).getValueAsString();
        } else if (byArray != null) {
            string = CardHelper.nameForAID(byArray, iccWrapper.getIccInformation().getMaskedAccountNumber(), iccWrapper.getIccInformation().getMaskedTrack2());
        }
        if (byArray != null) {
            iccWrapper.setApplicationIdentifier(byArray);
        }
        if (string != null) {
            iccWrapper.setApplicationName(string);
        }
    }

    public static void extractGenericDataToIccInformation(IccInformation iccInformation, List<TlvObject> iccData) {
        String string;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PrimitiveTlv primitiveTlv;
        PrimitiveTlv primitiveTlv2 = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationPrimaryAccountNumberSequenceNumber.TAG_BYTES, iccData);
        if (primitiveTlv2 != null) {
            primitiveTlv = TagApplicationPrimaryAccountNumberSequenceNumber.wrap(primitiveTlv2);
            object4 = primitiveTlv.getValueAsString();
            iccInformation.setCardSequenceNumber((String)object4);
        }
        if ((primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationExpiryDate.TAG_BYTES, iccData)) != null) {
            try {
                object4 = TagApplicationExpiryDate.wrap(primitiveTlv);
                object3 = ((TagApplicationExpiryDate)object4).getExpiryDate();
                iccInformation.setExpirationDate((String)object3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    object3 = TagApplicationExpiryDateCartesBancaires.wrap(primitiveTlv);
                    object2 = ((TagApplicationExpiryDateCartesBancaires)object3).getExtendedExpiryDate();
                    iccInformation.setExpirationDate((String)object2);
                }
                catch (IllegalArgumentException illegalArgumentException2) {}
            }
        }
        object4 = null;
        object3 = TLVHelper.findFirstPrimitiveItemInArray(TagCardholderNameExtended.TAG_BYTES, iccData);
        if (object3 != null) {
            object2 = TagCardholderNameExtended.wrap((PrimitiveTlv)object3);
            object4 = ((AbstractMappedPrimitiveTlv)object2).getValueAsString();
        }
        if (object4 == null) {
            object2 = TLVHelper.findFirstPrimitiveItemInArray(TagCardholderName.TAG_BYTES, iccData);
            try {
                if (object2 != null) {
                    object = TagCardholderName.wrap((PrimitiveTlv)object2);
                    object4 = ((AbstractMappedPrimitiveTlv)object).getValueAsString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w(TAG, "Error extracting TagCardholderName -> cardholderName will be null", illegalArgumentException);
            }
        }
        iccInformation.setCardholderName((String)object4);
        object2 = TLVHelper.findFirstPrimitiveItemInArray(TagTrack2EquivalentData.TAG_BYTES, iccData);
        if (object2 != null) {
            object = TagTrack2EquivalentData.wrap((PrimitiveTlv)object2).getValueAsString();
            string = CardHelper.maskTrack2Data((String)object);
            iccInformation.setMaskedTrack2(string);
        }
        if ((object = TLVHelper.findFirstPrimitiveItemInArray(TagApplicationPrimaryAccountNumber.TAG_BYTES, iccData)) != null) {
            string = TagApplicationPrimaryAccountNumber.wrap((PrimitiveTlv)object).getValueAsString();
            String string2 = CardHelper.maskAccountNumber(string);
            iccInformation.setMaskedAccountNumber(string2);
        }
    }

    public static CryptogramInformationData getCryptogramInformationData(List<TlvObject> tlvObjects) {
        Object[] objectArray = TLVHelper.stripAllPrivateTags(tlvObjects);
        PrimitiveTlv primitiveTlv = TLVHelper.findFirstPrimitiveItemInArray(TagCryptogramInformationData.TAG_BYTES, tlvObjects);
        if (TLVHelper.isTlvNotNullAndContainsValue(primitiveTlv)) {
            byte[] byArray = primitiveTlv.getValue();
            CryptogramInformationData cryptogramInformationData = new CryptogramInformationData(byArray[0]);
            if (cryptogramInformationData.getType() == ApplicationCryptogramType.RFU) {
                Log.w(TAG, "Only RFU CID found in tlv objects " + Arrays.toString(objectArray));
            }
            return cryptogramInformationData;
        }
        String cfr_ignored_0 = "No CID found in tlv objects " + Arrays.toString(objectArray);
        return null;
    }
}

