/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.iso7816.IsoBlockFrame;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

public class IsoBlockFrameReader {
    private static final String TAG = "IsoBlockFrameReader";
    private Queue<IsoBlockFrame> completeFrames = new LinkedList<IsoBlockFrame>();
    private int offset = 0;
    private byte[] currentResponse = null;
    private byte[] preBuffer;

    public boolean hasCompleteFrame() {
        return !this.completeFrames.isEmpty();
    }

    public IsoBlockFrame getNextFrame() {
        return this.completeFrames.poll();
    }

    public void process(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        this.process(byteBuffer);
    }

    public void process(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (this.preBuffer != null) {
            byte[] byArray2 = byteBuffer.array();
            byArray = new byte[byArray2.length + this.preBuffer.length];
            byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.put(this.preBuffer);
            byteBuffer.put(byArray2);
            byteBuffer.flip();
            this.preBuffer = null;
        }
        int n2 = byteBuffer.remaining();
        if (this.currentResponse == null && n2 < 3) {
            this.preBuffer = new byte[n2];
            byteBuffer.get(this.preBuffer);
            return;
        }
        if (this.currentResponse == null) {
            byArray = new byte[3];
            byteBuffer.get(byArray);
            int n3 = ByteHelper.signedByteToUnsigned(byArray[2]);
            this.currentResponse = new byte[n3 + 4];
            System.arraycopy(byArray, 0, this.currentResponse, 0, byArray.length);
            this.offset = 3;
        }
        n2 = byteBuffer.remaining();
        int n4 = Math.min(n2, this.currentResponse.length - this.offset);
        byte[] byArray3 = new byte[n4];
        byteBuffer.get(byArray3);
        System.arraycopy(byArray3, 0, this.currentResponse, this.offset, byArray3.length);
        this.offset += byArray3.length;
        if (this.offset == this.currentResponse.length) {
            this.completeFrames.add(IsoBlockFrame.deserialize(this.currentResponse));
            this.currentResponse = null;
            this.offset = 0;
        }
        if (byteBuffer.hasRemaining()) {
            this.process(byteBuffer);
        }
    }
}

