/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.TagHierarchyHelper;
import java.util.LinkedList;
import java.util.List;

public class TagExtractor {
    public static ConstructedTlv extractFirstTemplate(int tagBytes, TlvObject tlv) {
        return TagExtractor.extractFirstTemplate(ByteHelper.intToStrippedByteArray(tagBytes), tlv);
    }

    public static ConstructedTlv extractFirstTemplate(byte[] tagBytes, TlvObject tlv) {
        TlvObject tlvObject = TagExtractor.findFirstInternal(tagBytes, tlv);
        if (tlvObject instanceof ConstructedTlv) {
            return (ConstructedTlv)tlvObject;
        }
        return null;
    }

    public static boolean containsPrimitive(byte[] tagBytes, TlvObject tlv) {
        return TagExtractor.extractFirstPrimitive(tagBytes, tlv) != null;
    }

    public static PrimitiveTlv extractFirstPrimitive(byte[] tagBytes, TlvObject tlv) {
        TlvObject tlvObject = TagExtractor.findFirstInternal(tagBytes, tlv);
        if (tlvObject instanceof PrimitiveTlv) {
            return (PrimitiveTlv)tlvObject;
        }
        return null;
    }

    public static List<PrimitiveTlv> extractAllPrimitives(byte[] tagBytes, TlvObject tlv) {
        LinkedList<PrimitiveTlv> linkedList = new LinkedList<PrimitiveTlv>();
        TagExtractor.extractAllPrimitivesInternal(tagBytes, tlv, linkedList);
        return linkedList;
    }

    private static void extractAllPrimitivesInternal(byte[] tagBytes, TlvObject tlv, List<PrimitiveTlv> result) {
        if (TagHierarchyHelper.doesMatch(tagBytes, tlv) && tlv instanceof PrimitiveTlv) {
            result.add((PrimitiveTlv)tlv);
        }
        if (tlv instanceof ConstructedTlv) {
            for (TlvObject tlvObject : ((ConstructedTlv)tlv).getItems()) {
                TagExtractor.extractAllPrimitivesInternal(tagBytes, tlvObject, result);
            }
        }
    }

    private static TlvObject findFirstInternal(byte[] tagBytes, TlvObject tlv) {
        if (tlv == null) {
            throw new IllegalArgumentException("The TLV object must not be null");
        }
        if (tagBytes == null) {
            throw new IllegalArgumentException("The tagBytes array must not be null");
        }
        if (TagHierarchyHelper.doesMatch(tagBytes, tlv)) {
            return tlv;
        }
        if (tlv instanceof ConstructedTlv) {
            for (TlvObject tlvObject : ((ConstructedTlv)tlv).getItems()) {
                TlvObject tlvObject2 = TagExtractor.findFirstInternal(tagBytes, tlvObject);
                if (tlvObject2 == null) continue;
                return tlvObject2;
            }
        }
        return null;
    }
}

