/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.helper;

import io.mpos.specs.bertlv.ConstructedTlv;
import io.mpos.specs.bertlv.PrimitiveTlv;
import io.mpos.specs.bertlv.TlvObject;
import io.mpos.specs.helper.ByteHelper;
import io.mpos.specs.helper.EnDecodeHelper;
import java.util.Arrays;

public class TagLogHelper {
    public static void logFullTlv(String tag, TlvObject tlvObject) {
        if (tlvObject != null) {
            TagLogHelper.logFullTlv(tag, tlvObject, 0);
        }
    }

    private static void logFullTlv(String tag, TlvObject tlvObject, int level) {
        if (tlvObject == null) {
            return;
        }
        if (tlvObject instanceof ConstructedTlv) {
            if (tlvObject.getTagBytes() != null) {
                String cfr_ignored_0 = TagLogHelper.indent(level) + ByteHelper.toHexString(tlvObject.getTagBytes());
            }
            for (TlvObject tlvObject2 : ((ConstructedTlv)tlvObject).getItems()) {
                TagLogHelper.logFullTlv(tag, tlvObject2, level + 1);
            }
        } else {
            String cfr_ignored_1 = TagLogHelper.indent(level) + ByteHelper.toHexString(tlvObject.getTagBytes()) + " " + EnDecodeHelper.fromAscii(((PrimitiveTlv)tlvObject).getValue());
        }
    }

    private static String indent(int level) {
        char[] cArray = new char[level * 2];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }
}

