/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.iso7816;

import java.nio.ByteBuffer;

public class ApduCommand {
    public static final int TYPE_NODATA_NORESPONSE = 1;
    public static final int TYPE_NODATA_RESPONSE = 2;
    public static final int TYPE_DATA_NORESPONSE = 3;
    public static final int TYPE_DATA_RESPONSE = 4;
    public static final int SMALL_PACKET_MAX_SIZE = 255;
    public static final int BIG_PACKET_MAX_SIZE = 65535;
    private final byte cla;
    private final byte ins;
    private final byte p1;
    private final byte p2;
    private byte[] lc = new byte[]{0};
    private byte[] data = null;
    private byte le = 0;

    public ApduCommand(byte cla, byte ins, byte p1, byte p2) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
    }

    public ApduCommand(byte cla, byte ins, byte p1, byte p2, byte[] data) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.setData(data);
    }

    public ApduCommand(byte cla, byte ins, byte p1, byte p2, byte le) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.le = le;
    }

    public ApduCommand(byte cla, byte ins, byte p1, byte p2, byte[] data, byte le) {
        this.cla = cla;
        this.ins = ins;
        this.p1 = p1;
        this.p2 = p2;
        this.setData(data);
        this.le = le;
    }

    private void setData(byte[] data) {
        if (data.length > 65535) {
            throw new RuntimeException("data too big");
        }
        this.data = data;
        this.lc = this.getDataLength(data);
    }

    private byte[] getDataLength(byte[] data) {
        int n2 = data.length;
        if (n2 < 255) {
            return new byte[]{(byte)n2};
        }
        byte[] byArray = new byte[]{0, (byte)(n2 >>> 8), (byte)n2};
        return byArray;
    }

    public int getType() {
        boolean bl2;
        boolean bl3 = this.lc[0] != 0 || this.lc.length > 1;
        boolean bl4 = bl2 = this.le != 0;
        if (bl3) {
            if (bl2) {
                return 4;
            }
            return 3;
        }
        if (bl2) {
            return 2;
        }
        return 1;
    }

    public byte[] serialize() {
        ByteBuffer byteBuffer;
        int n2 = this.getType();
        switch (n2) {
            case 1: {
                byteBuffer = ByteBuffer.allocate(4);
                byteBuffer.put(this.cla);
                byteBuffer.put(this.ins);
                byteBuffer.put(this.p1);
                byteBuffer.put(this.p2);
                break;
            }
            case 2: {
                byteBuffer = ByteBuffer.allocate(5);
                byteBuffer.put(this.cla);
                byteBuffer.put(this.ins);
                byteBuffer.put(this.p1);
                byteBuffer.put(this.p2);
                byteBuffer.put(this.le);
                break;
            }
            case 3: {
                byteBuffer = ByteBuffer.allocate(4 + this.lc.length + this.data.length);
                byteBuffer.put(this.cla);
                byteBuffer.put(this.ins);
                byteBuffer.put(this.p1);
                byteBuffer.put(this.p2);
                byteBuffer.put(this.lc);
                byteBuffer.put(this.data);
                break;
            }
            case 4: {
                byteBuffer = ByteBuffer.allocate(5 + this.lc.length + this.data.length);
                byteBuffer.put(this.cla);
                byteBuffer.put(this.ins);
                byteBuffer.put(this.p1);
                byteBuffer.put(this.p2);
                byteBuffer.put(this.lc);
                byteBuffer.put(this.data);
                byteBuffer.put(this.le);
                break;
            }
            default: {
                throw new RuntimeException("Cannot serialize due to invalid type: " + n2);
            }
        }
        return byteBuffer.array();
    }

    public byte getCla() {
        return this.cla;
    }

    public byte getIns() {
        return this.ins;
    }

    public byte getP1() {
        return this.p1;
    }

    public byte getP2() {
        return this.p2;
    }

    public byte[] getLc() {
        return this.lc;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte getLe() {
        return this.le;
    }
}

