/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.specs.iso7816;

import io.mpos.specs.helper.ByteHelper;
import java.nio.ByteBuffer;

public class IsoBlockFrame {
    private byte nad;
    private byte pcb;
    private byte len;
    private byte[] inf;
    private byte lrc;

    public IsoBlockFrame(byte nad, byte pcb, byte[] inf) {
        if (inf == null) {
            throw new IllegalArgumentException("The INF field must not be null!");
        }
        if (inf.length > 255) {
            throw new IllegalArgumentException("The INF field is too long. It is expected to be less than 256 bytes long.");
        }
        this.nad = nad;
        this.pcb = pcb;
        this.len = (byte)inf.length;
        this.inf = inf;
        this.lrc = this.computeLrc();
    }

    public static IsoBlockFrame createUnsafeIsoBlockFrame(byte nad, byte pcb, byte[] inf) {
        return new IsoBlockFrame(nad, pcb, inf, true);
    }

    private IsoBlockFrame(byte nad, byte pcb, byte[] inf, boolean unsafe) {
        if (inf == null) {
            inf = new byte[]{};
        }
        this.nad = nad;
        this.pcb = pcb;
        this.len = 0;
        this.inf = inf;
        this.lrc = 0;
    }

    public static IsoBlockFrame deserialize(byte[] raw) {
        if (raw.length < 4) {
            throw new IllegalArgumentException("The raw array is not long enough.");
        }
        byte by2 = raw[0];
        byte by3 = raw[1];
        int n2 = ByteHelper.signedByteToUnsigned(raw[2]);
        if (raw.length != n2 + 4) {
            throw new IllegalArgumentException("The LEN field information is not correct. Got " + raw.length + " bytes in total, but the LEN field is " + n2 + "(+4)");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(raw, 3, byArray, 0, byArray.length);
        byte by4 = raw[raw.length - 1];
        IsoBlockFrame isoBlockFrame = new IsoBlockFrame(by2, by3, byArray);
        byte by5 = isoBlockFrame.getLrc();
        if (by4 != by5) {
            throw new IllegalArgumentException("The LRC field is not correct!" + ByteHelper.toHexString(by4) + "!=" + ByteHelper.toHexString(by5) + ". Data: " + ByteHelper.toHexShortString(raw));
        }
        return isoBlockFrame;
    }

    public byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.inf.length + 4);
        byteBuffer.put(this.nad);
        byteBuffer.put(this.pcb);
        byteBuffer.put(this.len);
        byteBuffer.put(this.inf);
        byteBuffer.put(this.lrc);
        return byteBuffer.array();
    }

    private byte computeLrc() {
        byte by2 = 0;
        by2 = (byte)(by2 ^ this.nad);
        by2 = (byte)(by2 ^ this.pcb);
        by2 = (byte)(by2 ^ this.len);
        for (int i2 = 0; i2 < this.inf.length; ++i2) {
            by2 = (byte)(by2 ^ this.inf[i2]);
        }
        return by2;
    }

    public byte getNad() {
        return this.nad;
    }

    public byte getPcb() {
        return this.pcb;
    }

    public byte getLen() {
        return this.len;
    }

    public byte[] getInf() {
        return this.inf;
    }

    public byte getLrc() {
        return this.lrc;
    }

    public String toString() {
        return "IsoBlockFrame{nad=" + ByteHelper.toHexString(this.nad) + ", pcb=" + ByteHelper.toHexString(this.pcb) + ", len=" + ByteHelper.toHexString(this.len) + ", inf=" + ByteHelper.toHexString(this.inf) + ", lrc=" + ByteHelper.toHexString(this.lrc) + "}";
    }
}

