/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.time;

import io.mpos.logger.LoggerKt;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/mpos/time/DateFormatter;", "", "format", "", "<init>", "(Ljava/lang/String;)V", "Ljava/text/SimpleDateFormat;", "stringFromDate", "date", "Ljava/util/Date;", "dateFromString", "string", "mpos.core"})
public final class DateFormatter {
    @NotNull
    private final SimpleDateFormat format;

    public DateFormatter(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"");
        this.format = new SimpleDateFormat(format);
    }

    @NotNull
    public final String stringFromDate(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"");
        String string = this.format.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    @Nullable
    public final Date dateFromString(@NotNull String string) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        try {
            date = this.format.parse(string);
        }
        catch (ParseException parseException) {
            LoggerKt.logWarn$default("DateFormatter", "Received invalid date string '" + string + "'  for given format: " + this.format.toPattern(), null, 4, null);
            date = null;
        }
        return date;
    }
}

