/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactionprovider.accessibility;

import io.mpos.paymentdetails.PinInformationStatus;
import io.mpos.transactionprovider.accessibility.RnibSpeaker;
import io.mpos.transactionprovider.accessibility.RnibTextToSpeechStateHolder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\rH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/mpos/transactionprovider/accessibility/RnibPinPadUpdatesHandler;", "", "speaker", "Lio/mpos/transactionprovider/accessibility/RnibSpeaker;", "stateHolder", "Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechStateHolder;", "<init>", "(Lio/mpos/transactionprovider/accessibility/RnibSpeaker;Lio/mpos/transactionprovider/accessibility/RnibTextToSpeechStateHolder;)V", "pinState", "Lio/mpos/transactionprovider/accessibility/RnibPinPadUpdatesHandler$PinEntry;", "clearPinPadEventSkipped", "", "pinStateChanged", "", "newState", "Lio/mpos/paymentdetails/PinInformationStatus;", "numberOfPinDigits", "", "onPinEntryStarted", "interruptIntroductionSpeech", "isThisClearPinpadEvent", "readPinIsIncorrect", "PinEntry", "mpos.core"})
public class RnibPinPadUpdatesHandler {
    @NotNull
    private final RnibSpeaker speaker;
    @NotNull
    private final RnibTextToSpeechStateHolder stateHolder;
    private PinEntry pinState;
    private boolean clearPinPadEventSkipped;

    public RnibPinPadUpdatesHandler(@NotNull RnibSpeaker speaker, @NotNull RnibTextToSpeechStateHolder stateHolder) {
        Intrinsics.checkNotNullParameter((Object)speaker, (String)"");
        Intrinsics.checkNotNullParameter((Object)stateHolder, (String)"");
        this.speaker = speaker;
        this.stateHolder = stateHolder;
    }

    public final void pinStateChanged(@NotNull PinInformationStatus newState, int numberOfPinDigits) {
        Intrinsics.checkNotNullParameter((Object)((Object)newState), (String)"");
        if (!this.stateHolder.getEnabled()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[newState.ordinal()]) {
            case 1: {
                this.onPinEntryStarted();
                break;
            }
            case 2: {
                this.interruptIntroductionSpeech(numberOfPinDigits);
                break;
            }
            case 3: {
                this.speaker.readPinAccepted();
                break;
            }
            case 4: 
            case 5: {
                this.readPinIsIncorrect();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void onPinEntryStarted() {
        this.speaker.readPinPadDescription(true);
        this.pinState = PinEntry.FIRST;
    }

    private final void interruptIntroductionSpeech(int numberOfPinDigits) {
        if (numberOfPinDigits > 0) {
            this.speaker.stopSpeaking();
            return;
        }
        if (!this.isThisClearPinpadEvent()) {
            this.speaker.stopSpeaking();
        }
    }

    private final boolean isThisClearPinpadEvent() {
        PinEntry pinEntry = this.pinState;
        if (pinEntry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            pinEntry = null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[pinEntry.ordinal()]) {
            case 1 -> false;
            case 2 -> {
                if (this.clearPinPadEventSkipped) {
                    yield false;
                }
                this.clearPinPadEventSkipped = true;
                yield true;
            }
            case 3 -> {
                if (this.clearPinPadEventSkipped) {
                    yield false;
                }
                this.clearPinPadEventSkipped = true;
                yield true;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void readPinIsIncorrect() {
        PinEntry pinEntry = this.pinState;
        if (pinEntry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"");
            pinEntry = null;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[pinEntry.ordinal()]) {
            case 1: {
                this.pinState = PinEntry.SECOND;
                this.speaker.readPinIncorrect();
                this.speaker.readPinPadDescription(false);
                break;
            }
            case 2: {
                this.pinState = PinEntry.LAST;
                this.clearPinPadEventSkipped = false;
                this.speaker.readPinIncorrect();
                this.speaker.readPinPadDescription(false);
                break;
            }
            case 3: {
                this.clearPinPadEventSkipped = false;
                this.speaker.readPinIncorrectOnLastTry();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/mpos/transactionprovider/accessibility/RnibPinPadUpdatesHandler$PinEntry;", "", "<init>", "(Ljava/lang/String;I)V", "FIRST", "SECOND", "LAST", "mpos.core"})
    private static final class PinEntry
    extends Enum<PinEntry> {
        public static final /* enum */ PinEntry FIRST = new PinEntry();
        public static final /* enum */ PinEntry SECOND = new PinEntry();
        public static final /* enum */ PinEntry LAST = new PinEntry();
        private static final /* synthetic */ PinEntry[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PinEntry[] values() {
            return (PinEntry[])$VALUES.clone();
        }

        public static PinEntry valueOf(String value) {
            return Enum.valueOf(PinEntry.class, value);
        }

        @NotNull
        public static EnumEntries<PinEntry> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pinEntryArray = new PinEntry[]{PinEntry.FIRST, PinEntry.SECOND, PinEntry.LAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PinInformationStatus.values().length];
            try {
                nArray[PinInformationStatus.STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinInformationStatus.UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinInformationStatus.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinInformationStatus.INCORRECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinInformationStatus.LAST_TRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PinEntry.values().length];
            try {
                nArray[PinEntry.FIRST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinEntry.SECOND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PinEntry.LAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

