/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactionprovider.accessibility;

import io.mpos.core.common.obfuscated.q;
import io.mpos.platform.PlatformToolkit;
import io.mpos.platform.TextToSpeechProxy;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactionprovider.accessibility.AccessibilityLocalization;
import io.mpos.transactions.Currency;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016J\b\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/mpos/transactionprovider/accessibility/RnibSpeaker;", "", "platformToolkit", "Lio/mpos/platform/PlatformToolkit;", "accessibilityLocalization", "Lio/mpos/transactionprovider/accessibility/AccessibilityLocalization;", "<init>", "(Lio/mpos/platform/PlatformToolkit;Lio/mpos/transactionprovider/accessibility/AccessibilityLocalization;)V", "stopSpeaking", "", "readIntro", "transaction", "Lio/mpos/shared/transactions/BaseTransaction;", "readTransactionAccepted", "readTransactionApproved", "readTransactionDecline", "readTransactionFailed", "readTransactionCanceled", "readRemoveCard", "readPinPadDescription", "speakImmediately", "", "readPinAccepted", "readPinIncorrect", "readPinIncorrectOnLastTry", "isSpeakingAvailable", "words", "", "speakEnqueued", "mpos.core"})
public class RnibSpeaker {
    @NotNull
    private final PlatformToolkit platformToolkit;
    @NotNull
    private final AccessibilityLocalization accessibilityLocalization;

    public RnibSpeaker(@NotNull PlatformToolkit platformToolkit, @NotNull AccessibilityLocalization accessibilityLocalization) {
        Intrinsics.checkNotNullParameter((Object)platformToolkit, (String)"");
        Intrinsics.checkNotNullParameter((Object)accessibilityLocalization, (String)"");
        this.platformToolkit = platformToolkit;
        this.accessibilityLocalization = accessibilityLocalization;
    }

    public void stopSpeaking() {
        block0: {
            TextToSpeechProxy textToSpeechProxy = this.platformToolkit.getTextToSpeechProxy();
            if (textToSpeechProxy == null) break block0;
            textToSpeechProxy.interrupt();
        }
    }

    public void readIntro(@NotNull BaseTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"");
        BigDecimal bigDecimal = transaction.getAmount();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"");
        Currency currency = transaction.getCurrency();
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"");
        this.speakImmediately(this.accessibilityLocalization.rnibIntro(bigDecimal, currency));
    }

    public void readTransactionAccepted() {
        this.speakEnqueued(this.accessibilityLocalization.rnibText(q.j));
    }

    public void readTransactionApproved() {
        this.speakEnqueued(this.accessibilityLocalization.rnibText(q.h));
    }

    public void readTransactionDecline() {
        this.speakEnqueued(this.accessibilityLocalization.rnibText(q.i));
    }

    public void readTransactionFailed() {
        this.speakImmediately(this.accessibilityLocalization.rnibText(q.g));
    }

    public void readTransactionCanceled() {
        this.speakImmediately(this.accessibilityLocalization.rnibText(q.f));
    }

    public void readRemoveCard() {
        this.speakEnqueued(this.accessibilityLocalization.rnibText(q.k));
    }

    public void readPinPadDescription(boolean speakImmediately) {
        if (speakImmediately) {
            this.speakImmediately(this.accessibilityLocalization.rnibText(q.b));
        } else {
            this.speakEnqueued(this.accessibilityLocalization.rnibText(q.b));
        }
    }

    public void readPinAccepted() {
        this.speakImmediately(this.accessibilityLocalization.rnibText(q.c));
    }

    public void readPinIncorrect() {
        this.speakImmediately(this.accessibilityLocalization.rnibText(q.d));
    }

    public void readPinIncorrectOnLastTry() {
        this.speakImmediately(this.accessibilityLocalization.rnibText(q.e));
    }

    public boolean isSpeakingAvailable() {
        return this.platformToolkit.getTextToSpeechProxy() != null;
    }

    private final void speakImmediately(String words) {
        this.stopSpeaking();
        this.speakEnqueued(words);
    }

    private final void speakEnqueued(String words) {
        block0: {
            TextToSpeechProxy textToSpeechProxy = this.platformToolkit.getTextToSpeechProxy();
            if (textToSpeechProxy == null) break block0;
            textToSpeechProxy.speak(words);
        }
    }
}

