/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.transactions.parameters;

import io.mpos.transactions.parameters.validation.ParametersValidationUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/mpos/transactions/parameters/TaxDetailsBuilder;", "", "<init>", "()V", "map", "", "", "merchantTaxId", "salesSlipNumber", "", "includedTaxAmount", "taxAmount", "Ljava/math/BigDecimal;", "includedLocalTaxAmount", "localTaxAmount", "includedNationalTaxAmount", "nationalTaxAmount", "build", "", "mpos.core"})
public final class TaxDetailsBuilder {
    @NotNull
    private final Map<String, String> map = new HashMap();

    @NotNull
    public final TaxDetailsBuilder merchantTaxId(@NotNull String merchantTaxId) {
        Intrinsics.checkNotNullParameter((Object)merchantTaxId, (String)"");
        ParametersValidationUtils.assertValidMerchantTaxId(merchantTaxId);
        this.map.put("merchantTaxId", merchantTaxId);
        return this;
    }

    @NotNull
    public final TaxDetailsBuilder salesSlipNumber(int salesSlipNumber) {
        ParametersValidationUtils.assertValidSalesSlipNumber(String.valueOf(salesSlipNumber));
        this.map.put("salesSlipNumber", String.valueOf(salesSlipNumber));
        return this;
    }

    @NotNull
    public final TaxDetailsBuilder includedTaxAmount(@NotNull BigDecimal taxAmount) {
        Intrinsics.checkNotNullParameter((Object)taxAmount, (String)"");
        ParametersValidationUtils.assertValidTaxAmount(taxAmount);
        this.map.put("taxAmount", taxAmount.toString());
        return this;
    }

    @NotNull
    public final TaxDetailsBuilder includedLocalTaxAmount(@NotNull BigDecimal localTaxAmount) {
        Intrinsics.checkNotNullParameter((Object)localTaxAmount, (String)"");
        ParametersValidationUtils.assertValidLocalOrNationalTaxAmount(localTaxAmount);
        this.map.put("localTaxAmount", localTaxAmount.toString());
        return this;
    }

    @NotNull
    public final TaxDetailsBuilder includedNationalTaxAmount(@NotNull BigDecimal nationalTaxAmount) {
        Intrinsics.checkNotNullParameter((Object)nationalTaxAmount, (String)"");
        ParametersValidationUtils.assertValidLocalOrNationalTaxAmount(nationalTaxAmount);
        this.map.put("nationalTaxAmount", nationalTaxAmount.toString());
        return this;
    }

    @NotNull
    public final Map<String, String> build() {
        return this.map;
    }
}

