/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Continuation;
import bolts.Task;
import io.mpos.core.common.obfuscated.aZ;
import io.mpos.core.common.obfuscated.bY;
import io.mpos.core.common.obfuscated.bd;
import io.mpos.core.common.obfuscated.cd;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.processors.payworks.services.response.DTOConversionHelper;
import io.mpos.shared.processors.payworks.services.response.dto.BackendErrorDTO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class ba
implements bd {
    private static final MediaType a = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient b;
    private final Json c;

    public ba(OkHttpClient okHttpClient, Json json) {
        this.b = okHttpClient;
        this.c = json;
    }

    @Override
    public void a(bd.a a2, String string, aZ<String> aZ2, Map<String, String> map, Map<String, String> map2) {
        Request request = this.a(a2, string, map, map2);
        this.a(request, aZ2);
    }

    @Override
    public void a(String string, aZ<String> aZ2, Map<String, String> map, File file) {
        if (file == null) {
            return;
        }
        Request request = this.a(string, map, file);
        this.a(request, aZ2);
    }

    private Request a(bd.a a2, String string, Map<String, String> map, Map<String, String> map2) {
        if (map2 == null && a2 == bd.a.a) {
            return new Request.Builder().url(string).headers(Headers.of(map)).build();
        }
        return new Request.Builder().url(string).headers(Headers.of(map)).method(this.a(a2), this.a(map2)).build();
    }

    private Request a(String string, Map<String, String> map, File file) {
        if (file == null) {
            throw new IllegalArgumentException("Expected file parameter");
        }
        MultipartBody multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/zip"), (File)file)).build();
        return new Request.Builder().url(string).headers(Headers.of(map)).method(this.a(bd.a.b), (RequestBody)multipartBody).build();
    }

    private <T> void a(Request request, final aZ<String> aZ2) {
        if (request == null) {
            return;
        }
        this.b.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e2) {
                Task.callInBackground(() -> {
                    aZ2.onHTTPServiceFailure(null, ba.a(e2));
                    return null;
                }).continueWith((Continuation)bY.a("HTTP request failed", aZ2));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                if (response.isSuccessful()) {
                    Task.callInBackground(() -> {
                        ResponseBody responseBody = response.body();
                        String string = "";
                        if (responseBody != null) {
                            string = responseBody.string();
                        }
                        aZ2.onHTTPServiceSuccess(null, string);
                        return null;
                    }).continueWith((Continuation)bY.a("HTTP successful request handling", aZ2));
                } else {
                    Task.callInBackground(() -> {
                        aZ2.onHTTPServiceFailure(null, ba.a(response, ba.this.c));
                        return null;
                    }).continueWith((Continuation)bY.a("HTTP unsuccessful request handling", aZ2));
                }
            }
        });
    }

    @Override
    public <T, Q> void a(bd.a a2, String string, Class<T> clazz, aZ<T> aZ2, Map<String, String> map, Q q2) {
        this.a(this.b, a2, string, clazz, aZ2, map, q2);
    }

    private <T> void a(OkHttpClient okHttpClient, Request request, final Class<T> clazz, final aZ<T> aZ2) {
        if (request == null) {
            return;
        }
        okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException ioException) {
                Log.w("OkHttpWrapper", "Failed:" + ioException.getLocalizedMessage(), ioException);
                Task.callInBackground(() -> {
                    aZ2.onHTTPServiceFailure(null, ba.a(ioException));
                    return null;
                }).continueWith((Continuation)bY.a("HTTP request failed", aZ2));
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                if (!response.isSuccessful()) {
                    Task.callInBackground(() -> {
                        aZ2.onHTTPServiceFailure(null, ba.a(response, ba.this.c));
                        return null;
                    }).continueWith((Continuation)bY.a("HTTP unsuccessful request handling", aZ2));
                } else {
                    Task.callInBackground(() -> {
                        Object t2 = ba.this.a(response, clazz);
                        aZ2.onHTTPServiceSuccess(null, t2);
                        return null;
                    }).continueWith((Continuation)bY.a("HTTP successful request handling", aZ2));
                }
            }
        });
    }

    private <T> T a(Response response, Class<T> clazz) throws IOException {
        Object object;
        try {
            object = JvmStreamsKt.decodeFromStream((Json)this.c, (DeserializationStrategy)SerializersKt.serializer(clazz), (InputStream)response.body().byteStream());
        }
        finally {
            response.body().close();
        }
        return (T)object;
    }

    private <T, Q> void a(OkHttpClient okHttpClient, bd.a a2, String string, Class<T> clazz, aZ<T> aZ2, Map<String, String> map, Q q2) {
        Request request = this.a(string, a2, map, q2);
        this.a(okHttpClient, request, clazz, aZ2);
    }

    private <Q> Request a(String string, bd.a a2, Map<String, String> map, Q q2) {
        Request.Builder builder = new Request.Builder().url(string).headers(Headers.of(map));
        if (a2 != bd.a.a) {
            builder.method(this.a(a2), new cd<Q>(a, q2, this.c));
        }
        return builder.build();
    }

    private RequestBody a(Map<String, String> map) {
        if (map == null) {
            throw new IllegalArgumentException("Expected map with body names and values");
        }
        FormBody.Builder builder = new FormBody.Builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new IllegalArgumentException("Body params cannot be null");
            }
            String string = entry.getKey().trim();
            String string2 = entry.getValue().trim();
            if (string.length() == 0 || string.indexOf(0) != -1 || string2.indexOf(0) != -1) {
                throw new IllegalArgumentException("Unexpected body param: " + string + ": " + string2);
            }
            builder.add(string, string2);
        }
        return builder.build();
    }

    private String a(bd.a a2) {
        switch (a2) {
            case a: 
            case b: 
            case c: 
            case d: 
            case e: {
                return a2.name();
            }
        }
        return "GET";
    }

    public static MposError a(Exception exception) {
        Log.w("OkHttpWrapper", "Request failed: " + exception + " " + Arrays.toString(exception.getStackTrace()));
        if (exception instanceof SSLHandshakeException || exception instanceof CertificateException) {
            return new DefaultMposError(ErrorType.SERVER_PINNING_WITH_REMOTE_FAILED, "SSL endpoint could not be verified. Please make sure you are able to connect directly to our backend. error=" + exception);
        }
        if (exception instanceof SocketTimeoutException) {
            return new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Server timeout, error=" + exception);
        }
        DefaultMposError defaultMposError = new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Server unavailable, error=" + exception);
        defaultMposError.add(exception);
        return defaultMposError;
    }

    public static MposError a(Response response, Json json) {
        Log.w("OkHttpWrapper", "Request failed: " + response + " ");
        String string = response.code() + ": " + response.message();
        if (response.code() == 504 || response.code() == 408) {
            return new DefaultMposError(ErrorType.SERVER_TIMEOUT, "Service timeout, error=" + string);
        }
        if (response.message() != null && response.message().contains("authentication challenges")) {
            return new DefaultMposError(ErrorType.SERVER_AUTHENTICATION_FAILED, "Authentication failed. Have you provided the correct merchant id and merchant secret?, error=" + string);
        }
        if (response.code() == 401) {
            return new DefaultMposError(ErrorType.SERVER_AUTHENTICATION_FAILED, "Authentication failed. Have you provided the correct merchant id and merchant secret?, error=" + string);
        }
        if (response.code() == 503) {
            return new DefaultMposError(ErrorType.SERVER_UNAVAILABLE, "Service unavailable, error= " + string);
        }
        if (response.code() == 413) {
            return new DefaultMposError(ErrorType.SERVER_PAYLOAD_EXCEEDED, "Server payload exceeded the maximum size");
        }
        String string2 = null;
        try {
            string2 = response.body().string();
            BackendErrorDTO backendErrorDTO = (BackendErrorDTO)json.decodeFromString((DeserializationStrategy)SerializersKt.serializer(BackendErrorDTO.class), string2);
            MposError mposError = new DTOConversionHelper().createMposError(backendErrorDTO);
            return mposError;
        }
        catch (Exception exception) {
            Log.w("OkHttpWrapper", "result of error mapping: " + exception.getLocalizedMessage());
            DefaultMposError defaultMposError = new DefaultMposError(ErrorType.SERVER_INVALID_RESPONSE, "Invalid response from server=" + string2);
            return defaultMposError;
        }
    }
}

