/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Task;
import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryState;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.accessories.components.barcode.BarcodeAccessoryComponent;
import io.mpos.accessories.components.barcode.BarcodeDetails;
import io.mpos.accessories.components.barcode.BarcodeScanMode;
import io.mpos.accessories.components.barcode.BarcodeScanTriggerType;
import io.mpos.accessories.components.barcode.StartScanListener;
import io.mpos.accessories.components.barcode.StartScanParameters;
import io.mpos.accessories.displayupdate.DisplayUpdateSupport;
import io.mpos.accessories.displayupdate.DisplayUpdateType;
import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.core.common.obfuscated.cU;
import io.mpos.core.common.obfuscated.cx;
import io.mpos.core.common.obfuscated.dB;
import io.mpos.core.common.obfuscated.dC;
import io.mpos.core.common.obfuscated.dz;
import io.mpos.core.common.obfuscated.et;
import io.mpos.core.common.obfuscated.gv;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.platform.EventDispatcher;
import io.mpos.provider.listener.AbortTransactionListener;
import io.mpos.provider.listener.ProviderComponentListener;
import io.mpos.provider.listener.TransactionListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListenerFactory;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.processors.payworks.services.response.dto.serialization.TransactionStatusDetailsCodesSerializer;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.provider.TransactionLocalRegistrationService;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.util.Pair;
import io.mpos.shared.util.TransactionConverterKt;
import io.mpos.transactionprovider.AccessoryConnectListener;
import io.mpos.transactionprovider.AccessoryDisconnectListener2;
import io.mpos.transactionprovider.AccessoryModule;
import io.mpos.transactionprovider.AccessoryProcess;
import io.mpos.transactionprovider.AccessoryProcessDetails;
import io.mpos.transactionprovider.AccessoryProcessDetailsState;
import io.mpos.transactionprovider.AccessoryProcessDetailsStateDetails;
import io.mpos.transactionprovider.AccessoryUpdateListener;
import io.mpos.transactionprovider.BasicTransactionProcessListener;
import io.mpos.transactionprovider.RegisteringTransactionProcessListener;
import io.mpos.transactionprovider.TransactionProcess;
import io.mpos.transactionprovider.TransactionProcessDetails;
import io.mpos.transactionprovider.TransactionProcessDetailsState;
import io.mpos.transactionprovider.TransactionProcessDetailsStateDetails;
import io.mpos.transactionprovider.TransactionProcessListener;
import io.mpos.transactions.AbortReason;
import io.mpos.transactions.Currency;
import io.mpos.transactions.Transaction;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.actionsupport.TransactionActionSupport;
import io.mpos.transactions.parameters.TransactionParameters;
import java.math.BigDecimal;
import java.util.concurrent.Callable;

public class cX
extends cU {
    private final DelayConfig a;
    private final BigDecimal b;
    private final Currency c;
    private DefaultTransaction d;
    private TransactionLocalRegistrationService e;
    private TransactionParameters f;
    private DefaultProvider g;
    private AccessoryParameters h;
    private AccessoryModule i;
    private dB j;
    private TransactionProcessListener k;
    private EventDispatcher l;
    private AccountParameters m;
    private ProcessTracker n;
    private AccessoryProcess o;
    private boolean p;
    private boolean q;
    private TransactionType r;
    private Accessory s;
    private BarcodeAccessoryComponent t;
    private AbortTransactionListener u;
    private gv v;
    private TransactionListener w = new TransactionListener(){

        @Override
        public void onTransactionApproved(BaseTransaction newTransaction) {
            if (cX.this.a(cX.this.d, newTransaction)) {
                cX.this.j.a(newTransaction);
                cX.this.a(newTransaction);
            }
        }

        @Override
        public void onTransactionDeclined(BaseTransaction newTransaction) {
            if (cX.this.a(cX.this.d, newTransaction)) {
                cX.this.j.a(newTransaction);
                cX.this.a(newTransaction);
            }
        }

        @Override
        public void onTransactionAborted(BaseTransaction newTransaction) {
        }

        @Override
        public void onTransactionFailure(BaseTransaction newTransaction, MposError error) {
            if (cX.this.a(cX.this.d, newTransaction)) {
                cX.this.j.a(error, newTransaction.getStatus() == TransactionStatus.INCONCLUSIVE, cX.this.r);
                cX.this.a();
            }
        }

        @Override
        public void onTransactionActionRequired(BaseTransaction transaction, TransactionAction action, TransactionActionSupport supportData) {
        }

        @Override
        public void onTransactionAbortSuccess(BaseTransaction transaction) {
        }

        @Override
        public void onTransactionAbortFailure(BaseTransaction transaction, MposError error) {
        }
    };
    private ProviderComponentListener x = new ProviderComponentListener(){

        @Override
        public void onTransactionStateChange(BaseTransaction transaction, TransactionState state, boolean canBeAborted) {
            if (state == TransactionState.AWAITING_COMPLETION) {
                cX.this.j.a(TransactionProcessDetailsStateDetails.PROCESSING_WAITING_FOR_PROCESSOR_APPROVAL, dz.a(cX.this.f));
            }
        }

        @Override
        public void onAccessoryStateChange(Accessory accessory, AccessoryState state) {
        }

        @Override
        public void onDisplayUpdate(String[] text, DisplayUpdateType type, DisplayUpdateSupport support) {
            if (cX.this.j.a().getStateDetails() == TransactionProcessDetailsStateDetails.PROCESSING_WAITING_FOR_PROCESSOR_APPROVAL) {
                cX.this.j.a(TransactionProcessDetailsStateDetails.PROCESSING_COMPLETED, et.a(text));
            } else if (((TransactionProcessDetailsStateDetails)cX.this.j.a().getStateDetails()).equals((Object)TransactionProcessDetailsStateDetails.PROCESSING_COMPLETED)) {
                cX.this.j.a((TransactionProcessDetailsStateDetails)cX.this.j.a().getStateDetails(), text);
            }
        }
    };

    public cX(BaseTransaction baseTransaction, TransactionParameters transactionParameters, final AccessoryParameters accessoryParameters, AccessoryModule accessoryModule, DefaultProvider defaultProvider, ProcessTracker processTracker, TransactionLocalRegistrationService transactionLocalRegistrationService, TransactionProcessListener transactionProcessListener, final gv gv2, DelayConfig delayConfig) {
        this.a = delayConfig;
        this.d = (DefaultTransaction)baseTransaction;
        this.f = transactionParameters;
        this.e = transactionLocalRegistrationService;
        this.h = accessoryParameters;
        this.i = accessoryModule;
        this.g = defaultProvider;
        this.k = transactionProcessListener;
        this.l = defaultProvider.getPlatformToolkit().getEventDispatcher();
        this.n = processTracker;
        this.v = gv2;
        this.p = false;
        this.q = false;
        this.r = transactionParameters != null ? dz.a(transactionParameters) : this.d.getType();
        this.b = transactionParameters != null ? transactionParameters.getAmount() : this.d.getAmount();
        this.c = transactionParameters != null ? transactionParameters.getCurrency() : this.d.getCurrency();
        this.j = new dB("BarcodeScannerTransactionProcess", this, this.l, (BasicTransactionProcessListener)this.k);
        this.u = new AbortTransactionListener(){

            @Override
            public void onTransactionAbortSuccess() {
                cX.this.j.a(TransactionProcessDetailsState.PROCESSING, TransactionProcessDetailsStateDetails.PROCESSING_COMPLETED);
                gv2.a((PaymentAccessory)cX.this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> cX.this.i(), (accessory, mposError) -> cX.this.i()), LocalizationPrompt.TRANSACTION_ABORTING, TransactionStatusDetailsCodes.ABORTED_MERCHANT_ABORTED, cX.this.r, DefaultTransaction.getWorkflowOrNull(cX.this.d), cX.this.b, cX.this.c);
            }

            @Override
            public void onTransactionAbortFailure(MposError error) {
                cX.this.j.a(error, false, cX.this.r);
                gv2.a((PaymentAccessory)cX.this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> {
                    if (!accessoryParameters.isKeepAlive()) {
                        cX.this.a((PaymentAccessory)cX.this.s);
                    } else {
                        cX.this.b();
                        ((PaymentAccessory)cX.this.s).getDisplayModule().displayIdleScreenAfterTimeout();
                    }
                }, (accessory, mposError) -> {
                    if (!accessoryParameters.isKeepAlive()) {
                        cX.this.a((PaymentAccessory)cX.this.s);
                    } else {
                        cX.this.b();
                        ((PaymentAccessory)cX.this.s).getDisplayModule().displayIdleScreenAfterTimeout();
                    }
                }), LocalizationPrompt.GENERIC_ERROR, new String[0]);
            }
        };
        this.j.a(TransactionProcessDetailsStateDetails.INITIALIZED, this.r);
    }

    @Override
    public void start() {
        this.d();
        this.o = this.i.connectToAccessory(this.h, new AccessoryConnectListener(){

            public void a(AccessoryProcess accessoryProcess, AccessoryProcessDetails accessoryProcessDetails) {
                if (AccessoryProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY.equals((Object)accessoryProcessDetails.getStateDetails())) {
                    cX.this.o = accessoryProcess;
                    cX.this.j.a(TransactionProcessDetailsState.CONNECTING_TO_ACCESSORY, TransactionProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY, cX.this.r, cX.this.f.getWorkflow());
                } else if (AccessoryProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY_RETRYING.equals((Object)accessoryProcessDetails.getStateDetails())) {
                    cX.this.j.a(TransactionProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY_WAITING_FOR_READER, accessoryProcessDetails.getInformation());
                }
            }

            public void a(Accessory accessory, AccessoryProcessDetails accessoryProcessDetails) {
                cX.this.s = accessory;
                if (AccessoryProcessDetailsState.COMPLETED.equals((Object)accessoryProcessDetails.getState())) {
                    cX.this.e();
                } else if (AccessoryProcessDetailsState.ABORTED.equals((Object)accessoryProcessDetails.getState())) {
                    cX.this.j.a(TransactionProcessDetailsState.ABORTED, TransactionProcessDetailsStateDetails.ABORTED, cX.this.r, cX.this.f.getWorkflow());
                    cX.this.b();
                } else if (AccessoryProcessDetailsState.FAILED.equals((Object)accessoryProcessDetails.getState())) {
                    cX.this.j.a(accessoryProcessDetails.getError(), false, cX.this.r, cX.this.f.getWorkflow());
                    cX.this.b();
                }
            }

            public /* synthetic */ void onCompleted(Object object, Object object2, Object object3) {
                AccessoryProcess cfr_ignored_0 = (AccessoryProcess)object;
                this.a((Accessory)object2, (AccessoryProcessDetails)object3);
            }

            public /* synthetic */ void onStatusChanged(Object object, Object object2, Object object3) {
                Accessory cfr_ignored_0 = (Accessory)object2;
                this.a((AccessoryProcess)object, (AccessoryProcessDetails)object3);
            }
        });
    }

    public Transaction getTransaction() {
        return TransactionConverterKt.toTransaction(this.d);
    }

    public Accessory getAccessory() {
        return this.s;
    }

    public TransactionProcessDetails getDetails() {
        return this.j.a();
    }

    public boolean canBeAborted() {
        boolean bl2 = this.o != null && this.o.canBeAborted();
        boolean bl3 = this.d != null && this.d.getStatus() == TransactionStatus.PENDING;
        return bl2 || this.p || bl3;
    }

    public boolean requestAbort() {
        if (!this.q && this.o != null && this.o.canBeAborted()) {
            this.q = true;
            if (this.t != null) {
                this.t.abort();
            }
            this.o.requestAbort();
            return true;
        }
        if (this.p && !this.q) {
            this.t.abort();
            return true;
        }
        if (this.d != null && this.d.getStatus() == TransactionStatus.PENDING) {
            cx.a(AbortReason.MERCHANT_ABORTED, this.d);
            this.f();
            return true;
        }
        return false;
    }

    public void removeTransactionProcessListener() {
        this.j.a((TransactionProcessListener)null);
    }

    public void setTransactionProcessListener(TransactionProcessListener listener) {
        this.j.a(listener);
    }

    private void a() {
        this.v.a((PaymentAccessory)this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.b(null), (accessory, mposError) -> this.b(null)), LocalizationPrompt.GENERIC_ERROR, new String[0]);
    }

    private void a(BaseTransaction baseTransaction) {
        this.v.a((PaymentAccessory)this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.b(baseTransaction), (accessory, mposError) -> this.b(baseTransaction)), LocalizationPrompt.COMPLETED_WITH_STATUS, baseTransaction.getStatusDetails().getCode(), baseTransaction.getType(), DefaultTransaction.getWorkflowOrNull(baseTransaction), baseTransaction.getAmount(), baseTransaction.getCurrency());
    }

    private void b(BaseTransaction baseTransaction) {
        if (baseTransaction != null && baseTransaction.getStatus() != null && baseTransaction.getStatus() != TransactionStatus.ERROR) {
            String string = TransactionStatusDetailsCodesSerializer.getInstance().serialize(baseTransaction.getStatusDetails().getCode());
            Pair<TransactionProcessDetailsState, TransactionProcessDetailsStateDetails> pair = dC.a(baseTransaction.getStatus());
            this.j.a(pair.getFirst(), pair.getSecond());
            this.j.a(this.r, string);
        }
        if (!this.h.isKeepAlive()) {
            this.a((PaymentAccessory)this.s);
        } else {
            this.b();
        }
    }

    private void b() {
        this.g.removeTransactionListener(this.w);
        this.g.removeProviderComponentListener(this.x);
        this.n.decrementNonCardProcessOngoing();
        this.j.d();
    }

    private StartScanParameters c() {
        return new StartScanParameters.Builder().triggerType(BarcodeScanTriggerType.BUTTON_PRESSED).mode(BarcodeScanMode.SINGLE).beep(true).build();
    }

    private AccountParameters a(String string, PaymentDetailsScheme paymentDetailsScheme) {
        String cfr_ignored_0 = "Creating account parameters for " + paymentDetailsScheme;
        if (paymentDetailsScheme == PaymentDetailsScheme.WECHAT_PAY) {
            return new AccountParameters.Builder().alternativePaymentMethod().weChatPay().shopperAccountIdentifier(PaymentDetailsSource.BARCODE, string).build();
        }
        return new AccountParameters.Builder().alternativePaymentMethod().alipay().shopperAccountIdentifier(PaymentDetailsSource.BARCODE, string).build();
    }

    private void d() {
        this.n.incrementNonCardProcessOngoing();
        this.g.addTransactionListener(this.w);
        this.g.addProviderComponentListener(this.x);
    }

    private void e() {
        this.o = this.i.updateAccessory(this.s, new AccessoryUpdateListener(){

            public void a(AccessoryProcessDetails accessoryProcessDetails) {
                switch ((AccessoryProcessDetailsStateDetails)accessoryProcessDetails.getStateDetails()) {
                    case CHECKING_FOR_UPDATE: {
                        cX.this.j.a(TransactionProcessDetailsState.CONNECTING_TO_ACCESSORY, TransactionProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY_CHECKING_FOR_UPDATE, cX.this.r);
                        break;
                    }
                    case UPDATING_ACCESSORY: {
                        cX.this.j.a(TransactionProcessDetailsState.CONNECTING_TO_ACCESSORY, TransactionProcessDetailsStateDetails.CONNECTING_TO_ACCESSORY_UPDATING, cX.this.r);
                    }
                }
            }

            public void b(AccessoryProcessDetails accessoryProcessDetails) {
                switch ((AccessoryProcessDetailsStateDetails)accessoryProcessDetails.getStateDetails()) {
                    case FAILED: {
                        MposError mposError = accessoryProcessDetails.getError() != null ? accessoryProcessDetails.getError() : new DefaultMposError(ErrorType.ACCESSORY_ERROR, "Accessory update failed");
                        cX.this.j.a(mposError, false, cX.this.r, cX.this.f.getWorkflow());
                        cX.this.b();
                        break;
                    }
                    case ABORTED: {
                        cX.this.j.a(TransactionProcessDetailsState.ABORTED, TransactionProcessDetailsStateDetails.ABORTED, cX.this.r, cX.this.f.getWorkflow());
                        cX.this.b();
                        break;
                    }
                    case COMPLETED: {
                        Task.callInBackground(cX.this.a(cX.this.c, cX.this.b));
                    }
                }
            }

            public /* synthetic */ void onCompleted(Object object, Object object2, Object object3) {
                AccessoryProcess cfr_ignored_0 = (AccessoryProcess)object;
                Accessory cfr_ignored_1 = (Accessory)object2;
                this.b((AccessoryProcessDetails)object3);
            }

            public /* synthetic */ void onStatusChanged(Object object, Object object2, Object object3) {
                AccessoryProcess cfr_ignored_0 = (AccessoryProcess)object;
                Accessory cfr_ignored_1 = (Accessory)object2;
                this.a((AccessoryProcessDetails)object3);
            }
        });
    }

    private void a(Accessory accessory) {
        StartScanParameters startScanParameters = this.c();
        this.t = (BarcodeAccessoryComponent)accessory.getAccessoryComponent(AccessoryComponentType.BARCODE_SCANNER);
        this.t.startScanner(startScanParameters, new StartScanListener(){

            @Override
            public void ready() {
                cX.this.p = true;
                String string = new CurrencyWrapper(cX.this.c, cX.this.g.getLocale()).formatAmountAndCurrency(cX.this.b);
                cX.this.j.a(TransactionProcessDetailsState.WAITING_FOR_SCAN, TransactionProcessDetailsStateDetails.PROCESSING_WAITING_FOR_SCAN, string);
            }

            @Override
            public void scan(BarcodeDetails barcodeDetails) {
                cX.this.p = false;
                cX.this.a(barcodeDetails.getBarcode(), cX.this.d, cX.this.f);
            }

            @Override
            public void aborted() {
                cX.this.p = false;
                if (cX.this.d != null) {
                    cx.a(AbortReason.MERCHANT_ABORTED, cX.this.d);
                    cX.this.j.a(cX.this.d);
                    cX.this.f();
                } else {
                    cX.this.j.a(TransactionProcessDetailsState.PROCESSING, TransactionProcessDetailsStateDetails.PROCESSING_COMPLETED);
                    cX.this.i();
                }
            }

            @Override
            public void failure(MposError error) {
                cX.this.j.a(error, false, cX.this.r);
                cX.this.a();
                cX.this.p = false;
            }
        });
    }

    private void f() {
        this.g.addTransactionVoidingListener(this.u);
        this.g.abortTransaction(this.d.getSessionIdentifier(), AbortReason.MERCHANT_ABORTED);
    }

    private Callable<Void> a(Currency currency, BigDecimal bigDecimal) {
        return () -> {
            this.v.a((PaymentAccessory)this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.a(this.s), (accessory, mposError) -> {
                this.j.a(mposError, false, this.r);
                this.a((PaymentAccessory)accessory);
            }), LocalizationPrompt.SCAN_CODE, new CurrencyWrapper(currency, this.g.getLocale()).formatAmountAndCurrency(bigDecimal));
            return null;
        };
    }

    private void g() {
        this.l.fire(() -> {
            if (this.k instanceof RegisteringTransactionProcessListener) {
                ((RegisteringTransactionProcessListener)this.k).onRegistered((TransactionProcess)this, TransactionConverterKt.toTransaction(this.d));
            }
        });
        this.j.a(TransactionProcessDetailsStateDetails.PROCESSING, this.r);
        this.h();
    }

    private void h() {
        PaymentAccessory paymentAccessory = (PaymentAccessory)this.s;
        this.v.a(paymentAccessory, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.g.executeTransaction(this.d, this.m), (accessory, mposError) -> this.g.executeTransaction(this.d, this.m)), LocalizationPrompt.PROCESSING_TRANSACTION, this.d == null ? null : this.d.getAmount(), this.d == null ? null : this.d.getCurrency(), new String[0]);
    }

    private void i() {
        Task.delay((long)this.a.getBarcodeDeviceDelay()).continueWith(task -> {
            this.v.a((PaymentAccessory)this.s, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> {
                this.j.a(TransactionProcessDetailsState.ABORTED, TransactionProcessDetailsStateDetails.ABORTED, this.r);
                if (!this.h.isKeepAlive()) {
                    this.a((PaymentAccessory)this.s);
                } else {
                    this.b();
                    ((PaymentAccessory)this.s).getDisplayModule().displayIdleScreenAfterTimeout();
                }
                if (this.d != null) {
                    this.g.removeTransactionVoidingListener(this.u);
                }
            }, (accessory, mposError) -> {
                this.j.a(TransactionProcessDetailsState.ABORTED, TransactionProcessDetailsStateDetails.ABORTED);
                if (this.d != null) {
                    this.g.removeTransactionVoidingListener(this.u);
                }
                this.j.a(mposError, false, this.r);
                this.a((PaymentAccessory)this.s);
            }), LocalizationPrompt.COMPLETED_WITH_STATUS, TransactionStatusDetailsCodes.ABORTED_MERCHANT_ABORTED, this.r, DefaultTransaction.getWorkflowOrNull(this.d), this.d == null ? null : this.d.getAmount(), this.d == null ? null : this.d.getCurrency());
            return null;
        });
    }

    void a(PaymentAccessory paymentAccessory) {
        Task.delay((long)this.a.getDeviceDisconnectDelay()).continueWith(task -> {
            this.i.disconnectFromAccessory((Accessory)paymentAccessory, new AccessoryDisconnectListener2(){

                public void a(AccessoryProcessDetails accessoryProcessDetails) {
                    if (accessoryProcessDetails.getError() != null) {
                        Log.i("BarcodeScannerTransactionProcess", "accessory disconnect failure: " + accessoryProcessDetails.getError());
                    } else {
                        Log.i("BarcodeScannerTransactionProcess", "accessory disconnect success");
                    }
                    cX.this.b();
                }

                public /* synthetic */ void onCompleted(Object object, Object object2, Object object3) {
                    AccessoryProcess cfr_ignored_0 = (AccessoryProcess)object;
                    Accessory cfr_ignored_1 = (Accessory)object2;
                    this.a((AccessoryProcessDetails)object3);
                }
            });
            return null;
        });
    }

    private void a(String string, DefaultTransaction defaultTransaction, TransactionParameters transactionParameters) {
        if (defaultTransaction == null) {
            this.m = this.a(string, transactionParameters.getScheme());
            this.d = this.e.createFromTransactionParametersAndAccountParameters(transactionParameters, this.m);
        } else {
            this.m = this.a(string, defaultTransaction.getPaymentDetails().getScheme());
            this.d = defaultTransaction;
        }
        this.j.a(this.d);
        this.g();
    }
}

