/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.core.common.obfuscated.cW;
import io.mpos.core.common.obfuscated.cX;
import io.mpos.core.common.obfuscated.cY;
import io.mpos.core.common.obfuscated.cZ;
import io.mpos.core.common.obfuscated.dj;
import io.mpos.core.common.obfuscated.dk;
import io.mpos.core.common.obfuscated.dm;
import io.mpos.core.common.obfuscated.do;
import io.mpos.core.common.obfuscated.dp;
import io.mpos.core.common.obfuscated.du;
import io.mpos.core.common.obfuscated.es;
import io.mpos.core.common.obfuscated.gw;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Helper;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.provider.TransactionLocalRegistrationService;
import io.mpos.shared.transactionprovider.DefaultAccessoryModule;
import io.mpos.shared.transactionprovider.DefaultTransactionProvider;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.transactionprovider.AccessoryModule;
import io.mpos.transactionprovider.BasicTransactionProcessListener;
import io.mpos.transactionprovider.BasicTransactionProcessWithRegistrationListener;
import io.mpos.transactionprovider.DefaultAccessibilityModule;
import io.mpos.transactionprovider.StartableTransactionProcess;
import io.mpos.transactionprovider.TransactionProcessListener;
import io.mpos.transactionprovider.processparameters.TransactionProcessParameters;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.TransactionWorkflowType;
import io.mpos.transactions.account.AccountParameters;
import io.mpos.transactions.parameters.TransactionParameters;
import java.math.BigDecimal;
import org.jetbrains.annotations.NotNull;

public class dA {
    private DefaultProvider a;
    private DefaultTransactionProvider b;
    private TransactionLocalRegistrationService c;
    private DefaultAccessoryModule d;
    private DefaultAccessibilityModule e;
    private ProcessTracker f;
    private final DelayConfig g;
    private final Profiler h;

    public dA(DefaultProvider defaultProvider, TransactionLocalRegistrationService transactionLocalRegistrationService, DefaultAccessoryModule defaultAccessoryModule, DefaultAccessibilityModule defaultAccessibilityModule, ProcessTracker processTracker, DefaultTransactionProvider defaultTransactionProvider, DelayConfig delayConfig, Profiler profiler) {
        this.a = defaultProvider;
        this.c = transactionLocalRegistrationService;
        this.d = defaultAccessoryModule;
        this.e = defaultAccessibilityModule;
        this.f = processTracker;
        this.b = defaultTransactionProvider;
        this.g = delayConfig;
        this.h = profiler;
    }

    public StartableTransactionProcess a(String string, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener transactionProcessListener) {
        return new dp(string, this.a, this.f, accessoryParameters, this.d, this.c, transactionProcessParameters, transactionProcessListener, this, new es(LocalizationServer.getInstance()), new do(new gw()), this.g);
    }

    public StartableTransactionProcess a(TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener transactionProcessListener) {
        switch (transactionParameters.getParametersType()) {
            case REFUND: {
                this.b.assertCardProcessNotOngoing();
                if (transactionParameters.getWorkflow() == TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD) {
                    throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + transactionParameters.getParametersType() + " TransactionParameters and " + transactionParameters.getWorkflow() + " Workflow!"));
                }
                if (transactionParameters.getReferencedTransactionIdentifier() != null) {
                    Log.w("TransactionProcessFactory", "Deprecated, accessory parameters are being ignored. Please use refund transaction parameters with the amendTransaction() method.");
                    return new dk(this.a, TransactionMode.ONLINE, this.f, transactionParameters, (BasicTransactionProcessListener)transactionProcessListener, this.h);
                }
                return this.a(TransactionMode.ONLINE, transactionParameters, accessoryParameters, transactionProcessParameters, transactionProcessListener, null, null);
            }
            case CHARGE: 
            case VERIFICATION: {
                switch (transactionParameters.getWorkflow()) {
                    case ALTERNATIVE_PAYMENT_METHOD: {
                        this.b.assertNonCardProcessNotOngoing();
                        return new cX(null, transactionParameters, accessoryParameters, this.d, this.a, this.f, this.c, transactionProcessListener, new gw(), this.g);
                    }
                    case GIFT_CARD: {
                        this.b.assertCardProcessNotOngoing();
                        return new du(this.h).a(this.f, this.a, this.d, transactionParameters, accessoryParameters, transactionProcessListener, this.g);
                    }
                }
                BigDecimal bigDecimal = transactionParameters.getCashbackAmount();
                if (bigDecimal != null && !transactionParameters.isAutoCapture() && bigDecimal.compareTo(BigDecimal.ZERO) >= 0) {
                    throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.CASHBACK_NOT_ALLOWED_ON_PRE_AUTH_TRANSACTION, "Cashback cannot be performed for pre-authorizations."));
                }
                this.b.assertCardProcessNotOngoing();
                return this.a(TransactionMode.ONLINE, transactionParameters, accessoryParameters, transactionProcessParameters, transactionProcessListener, null, null);
            }
            case ACTIVATION: 
            case BALANCE_INQUIRY: 
            case CASHOUT: {
                return new du(this.h).a(this.f, this.a, this.d, transactionParameters, accessoryParameters, transactionProcessListener, this.g);
            }
        }
        throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + transactionParameters.getParametersType() + " TransactionParameters!"));
    }

    public StartableTransactionProcess a(BaseTransaction baseTransaction, AccessoryParameters accessoryParameters, AccessoryModule accessoryModule, DefaultProvider defaultProvider, ProcessTracker processTracker, TransactionLocalRegistrationService transactionLocalRegistrationService, TransactionProcessListener transactionProcessListener, TransactionProcessParameters transactionProcessParameters) {
        TransactionWorkflowType transactionWorkflowType = ((DefaultTransaction)baseTransaction).getWorkflow();
        switch (transactionWorkflowType) {
            case ALTERNATIVE_PAYMENT_METHOD: {
                return new cX(baseTransaction, null, accessoryParameters, accessoryModule, defaultProvider, processTracker, transactionLocalRegistrationService, transactionProcessListener, new gw(), this.g);
            }
            case GIFT_CARD: {
                return new du(this.h).a(processTracker, this.a, accessoryModule, baseTransaction, accessoryParameters, transactionProcessListener, this.g);
            }
        }
        return this.a(TransactionMode.ONLINE, null, accessoryParameters, transactionProcessParameters, transactionProcessListener, null, baseTransaction);
    }

    public StartableTransactionProcess a(AccountParameters accountParameters, String string, BasicTransactionProcessWithRegistrationListener basicTransactionProcessWithRegistrationListener) {
        if (accountParameters.getScheme() == PaymentDetailsScheme.CYBERSOURCE_TOKEN) {
            return new cW(this.a, this.f, this.c, null, accountParameters, string, basicTransactionProcessWithRegistrationListener);
        }
        throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + accountParameters.getScheme() + " AccountParameters scheme!"));
    }

    public StartableTransactionProcess a(TransactionParameters transactionParameters, AccountParameters accountParameters, BasicTransactionProcessWithRegistrationListener basicTransactionProcessWithRegistrationListener) {
        TransactionWorkflowType transactionWorkflowType = transactionParameters.getWorkflow();
        PaymentDetailsScheme paymentDetailsScheme = transactionParameters.getScheme();
        PaymentDetailsScheme paymentDetailsScheme2 = accountParameters.getScheme();
        TransactionParameters.Type type = transactionParameters.getParametersType();
        if (transactionWorkflowType == TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD && paymentDetailsScheme != null && !Helper.isInEnum(paymentDetailsScheme, PaymentDetailsScheme.ALIPAY, PaymentDetailsScheme.WECHAT_PAY)) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "ALTERNATIVE_PAYMENT_METHOD workflow must have either ALIPAY or WECHAT_PAY as a scheme."));
        }
        if (transactionWorkflowType == TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD && type == TransactionParameters.Type.CHARGE && Helper.isInEnum(paymentDetailsScheme2, PaymentDetailsScheme.ALIPAY, PaymentDetailsScheme.WECHAT_PAY) || type == TransactionParameters.Type.REFUND && paymentDetailsScheme2 == PaymentDetailsScheme.CYBERSOURCE_TOKEN) {
            return new cW(this.a, this.f, this.c, transactionParameters, accountParameters, null, basicTransactionProcessWithRegistrationListener);
        }
        throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + transactionParameters.getParametersType() + " TransactionParameters!"));
    }

    public StartableTransactionProcess a(TransactionParameters transactionParameters, BasicTransactionProcessListener basicTransactionProcessListener) {
        if (transactionParameters.getWorkflow() == TransactionWorkflowType.ALTERNATIVE_PAYMENT_METHOD) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + transactionParameters.getParametersType() + " TransactionParameters and " + transactionParameters.getWorkflow() + " Workflow!"));
        }
        switch (transactionParameters.getParametersType()) {
            case REFUND: {
                return new dk(this.a, TransactionMode.ONLINE, this.f, transactionParameters, basicTransactionProcessListener, this.h);
            }
            case CAPTURE: {
                return new cY(this.a, this.f, transactionParameters, basicTransactionProcessListener, this.h);
            }
            case TIP_ADJUST: {
                return new dm(this.a, this.f, transactionParameters, basicTransactionProcessListener, this.h);
            }
            case INCREMENTAL_AUTHORIZATION: {
                return new dj(this.a, this.f, transactionParameters, basicTransactionProcessListener, this.h);
            }
        }
        throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create a process for " + transactionParameters.getParametersType() + " TransactionParameters!"));
    }

    public StartableTransactionProcess b(TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener transactionProcessListener) {
        if (!TransactionWorkflowType.POS.equals((Object)transactionParameters.getWorkflow())) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("Cannot create an offline start process for workflow %s. The workflow can only be POS.", transactionParameters.getWorkflow())));
        }
        if (!TransactionParameters.Type.CHARGE.equals((Object)transactionParameters.getParametersType())) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("Cannot create an offline start process for parameters type %s. The parameters type can only be CHARGE.", transactionParameters.getParametersType())));
        }
        if (transactionParameters.isTipAdjustable()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create an offline start process. Tip adjustable charge transactions are not supported in offline mode."));
        }
        if (!transactionParameters.isAutoCapture()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create an offline start process. Pre-Authorization is not supported in offline transactions."));
        }
        if (transactionParameters.getCashbackAmount() != null) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Cannot create an offline start process. Cashback is not supported in offline transactions."));
        }
        return this.a(TransactionMode.OFFLINE, transactionParameters, accessoryParameters, transactionProcessParameters, transactionProcessListener, null, null);
    }

    @NotNull
    private cZ a(TransactionMode transactionMode, TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener transactionProcessListener, String string, BaseTransaction baseTransaction) {
        return new cZ(this.a, transactionMode, this.d, this.e, this.f, transactionParameters, accessoryParameters, transactionProcessParameters, transactionProcessListener, string, baseTransaction, this.g, this.h);
    }

    public StartableTransactionProcess b(TransactionParameters transactionParameters, BasicTransactionProcessListener basicTransactionProcessListener) {
        if (!TransactionWorkflowType.POS.equals((Object)transactionParameters.getWorkflow())) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("Cannot create an offline amendment process for workflow %s. The workflow can only be POS.", transactionParameters.getWorkflow())));
        }
        if (!TransactionParameters.Type.REFUND.equals((Object)transactionParameters.getParametersType())) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, String.format("Cannot create an offline amendment process with parameters type %s. The parameters type can only be REFUND.", transactionParameters.getParametersType())));
        }
        if (transactionParameters.getReferencedTransactionIdentifier() == null || transactionParameters.getReferencedTransactionIdentifier().length() == 0) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.PARAMETER_INVALID, "Standalone refunds are not supported for offline transactions. You need to pass a referenced transaction ID."));
        }
        return new dk(this.a, TransactionMode.OFFLINE, this.f, transactionParameters, basicTransactionProcessListener, this.h);
    }
}

