/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.accessories.parameters.AccessoryParameters;
import io.mpos.core.common.obfuscated.dA;
import io.mpos.core.common.obfuscated.dE;
import io.mpos.core.common.obfuscated.dG;
import io.mpos.core.common.obfuscated.dH;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.provider.Provider;
import io.mpos.provider.listener.QueryTransactionsListener;
import io.mpos.provider.listener.TransactionLookupWithTransactionIdentifierListener;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.ParameterValidator;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.provider.DefaultProvider;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.util.TransactionConverterKt;
import io.mpos.transactionprovider.BasicTransactionProcessListener;
import io.mpos.transactionprovider.DeleteStoredConfigurationsListener;
import io.mpos.transactionprovider.DeleteStoredTransactionsListener;
import io.mpos.transactionprovider.FilterParameters;
import io.mpos.transactionprovider.LookupTransactionListener;
import io.mpos.transactionprovider.StartableTransactionProcess;
import io.mpos.transactionprovider.SubmitTransactionsBatchProcess;
import io.mpos.transactionprovider.TransactionProcess;
import io.mpos.transactionprovider.TransactionProcessListener;
import io.mpos.transactionprovider.offline.OfflineModule;
import io.mpos.transactionprovider.offline.SubmitTransactionsBatchProcessListener;
import io.mpos.transactionprovider.processparameters.TransactionProcessParameters;
import io.mpos.transactions.TransactionMode;
import io.mpos.transactions.parameters.TransactionParameters;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class dD
implements OfflineModule {
    private final DefaultProvider a;
    private final ProcessTracker b;
    private final dA c;
    private final Profiler d;

    public dD(Provider provider, ProcessTracker processTracker, dA dA2, Profiler profiler) {
        this.a = (DefaultProvider)provider;
        this.b = processTracker;
        this.c = dA2;
        this.d = profiler;
    }

    public TransactionProcess startTransaction(TransactionParameters transactionParameters, AccessoryParameters accessoryParameters, TransactionProcessParameters transactionProcessParameters, TransactionProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(transactionParameters, accessoryParameters, listener), Arrays.asList("transactionParameters", "accessoryParameters", "listener"));
        if (this.b.isCardProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A process is already ongoing!"));
        }
        StartableTransactionProcess startableTransactionProcess = this.c.b(transactionParameters, accessoryParameters, transactionProcessParameters, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public TransactionProcess amendTransaction(TransactionParameters transactionParameters, BasicTransactionProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(transactionParameters, listener), Arrays.asList("transactionParameters", "listener"));
        StartableTransactionProcess startableTransactionProcess = this.c.b(transactionParameters, listener);
        startableTransactionProcess.start();
        return startableTransactionProcess;
    }

    public SubmitTransactionsBatchProcess submitTransactionsBatch(SubmitTransactionsBatchProcessListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("listener"));
        if (this.b.isBatchSubmissionProcessOngoing()) {
            throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_BUSY, "A process is already ongoing!"));
        }
        dE dE2 = new dE(this.a, submitTransactionsBatchProcessDetails -> {
            this.b.setBatchSubmissionProcessOngoing(false);
            listener.onCompleted(submitTransactionsBatchProcessDetails);
        }, this.d);
        this.b.setBatchSubmissionProcessOngoing(true);
        dE2.a();
        return dE2;
    }

    public void lookupTransaction(final String transactionIdentifier, final LookupTransactionListener listener) {
        ParameterValidator.checkNullOrEmpty(Arrays.asList(transactionIdentifier), Arrays.asList("transactionIdentifier"));
        this.b.incrementNonCardProcessOngoing();
        this.d.resetFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER, TransactionMode.OFFLINE);
        this.a.addTransactionLookupWithTransactionIdentifierListener(new TransactionLookupWithTransactionIdentifierListener(){

            @Override
            public void onTransactionLookupWithTransactionIdentifierSuccess(String returnedTransactionIdentifier, BaseTransaction transaction) {
                if (returnedTransactionIdentifier != null && returnedTransactionIdentifier.equals(transactionIdentifier)) {
                    dD.this.b.decrementNonCardProcessOngoing();
                    dD.this.a.removeTransactionLookupWithTransactionIdentifierListener(this);
                    dD.this.d.persistFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
                    listener.onCompleted(transactionIdentifier, TransactionConverterKt.toTransaction(transaction), null);
                }
            }

            @Override
            public void onTransactionLookupWithTransactionIdentifierFailure(String returnedTransactionIdentifier, MposError error) {
                if (returnedTransactionIdentifier != null && returnedTransactionIdentifier.equals(transactionIdentifier)) {
                    dD.this.b.decrementNonCardProcessOngoing();
                    dD.this.a.removeTransactionLookupWithTransactionIdentifierListener(this);
                    dD.this.d.persistFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
                    listener.onCompleted(transactionIdentifier, null, error);
                }
            }
        });
        this.a.lookupTransactionWithTransactionIdentifierOffline(transactionIdentifier);
    }

    public void queryTransactions(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, final io.mpos.transactionprovider.QueryTransactionsListener listener) {
        if (filterParameters == null) {
            filterParameters = new FilterParameters.Builder().build();
        }
        this.b.incrementNonCardProcessOngoing();
        this.d.resetFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER, TransactionMode.OFFLINE);
        this.a.addQueryTransactionsListener(new QueryTransactionsListener(){

            @Override
            public void onQueryTransactionsSuccess(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, List<BaseTransaction> transactions) {
                dD.this.b.decrementNonCardProcessOngoing();
                dD.this.a.removeQueryTransactionsListener(this);
                dD.this.d.persistFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
                listener.onCompleted(filterParameters, includeReceipts, offset, limit, transactions.stream().map(TransactionConverterKt::toTransaction).collect(Collectors.toList()), null);
            }

            @Override
            public void onQueryTransactionsFailure(FilterParameters filterParameters, boolean includeReceipts, int offset, int limit, MposError error) {
                dD.this.b.decrementNonCardProcessOngoing();
                dD.this.a.removeQueryTransactionsListener(this);
                dD.this.d.persistFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
                listener.onCompleted(filterParameters, includeReceipts, offset, limit, null, error);
            }
        });
        this.a.queryTransactionsOffline(filterParameters, includeReceipts, offset, limit);
    }

    public void deleteStoredTransactions(DeleteStoredTransactionsListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("listener"));
        this.b.incrementNonCardProcessOngoing();
        dH dH2 = new dH(this.a, mposError -> {
            this.b.decrementNonCardProcessOngoing();
            listener.onCompleted(mposError);
        });
        dH2.a();
    }

    public void deleteStoredConfigurations(DeleteStoredConfigurationsListener listener) {
        ParameterValidator.checkNull(Arrays.asList(listener), Arrays.asList("listener"));
        this.b.incrementNonCardProcessOngoing();
        dG dG2 = new dG(this.a, mposError -> {
            this.b.decrementNonCardProcessOngoing();
            listener.onCompleted(mposError);
        });
        dG2.a();
    }
}

