/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import bolts.Task;
import io.mpos.accessories.components.AccessoryComponentType;
import io.mpos.accessories.components.interaction.AbortReason;
import io.mpos.accessories.components.interaction.AskForCardDataListener;
import io.mpos.accessories.components.interaction.AskForNumberListener;
import io.mpos.accessories.components.interaction.CardData;
import io.mpos.accessories.components.interaction.CardDataPrompt;
import io.mpos.accessories.components.interaction.DefaultCardData;
import io.mpos.accessories.components.interaction.InteractionComponent;
import io.mpos.accessories.components.interaction.InteractionPrompt;
import io.mpos.accessories.components.interaction.parameters.AskForCardDataParameters;
import io.mpos.accessories.components.interaction.parameters.AskForNumberInteractionParameters;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.core.common.obfuscated.fL;
import io.mpos.core.common.obfuscated.fW;
import io.mpos.core.common.obfuscated.ff;
import io.mpos.core.common.obfuscated.gV;
import io.mpos.core.common.obfuscated.gv;
import io.mpos.core.common.obfuscated.s;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.paymentdetails.PaymentDetailsSource;
import io.mpos.shared.accessories.ProcessingOnDeviceMeasurement;
import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.accessories.modules.listener.CardProcessingDetectCardListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListenerFactory;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.config.DelayConfig;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.MagstripeInformation;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsMagstripeWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsManualInputWrapper;
import io.mpos.shared.paymentdetails.PaymentDetailsSchemesContainer;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.provider.CardHelper;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.workflows.PaymentWorkflowState;
import io.mpos.transactions.Currency;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.TransactionWorkflowType;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Locale;
import javax.inject.Inject;

public class fE
extends fW {
    private final byte a = 1;
    private final byte b = (byte)8;
    private final String c = "GiftCardTransactionWorkflow";
    private final String d = fE.class.getSimpleName();
    private final s e;
    private final Locale f;
    private final DelayConfig g;

    @Inject
    public fE(TransactionProcessor transactionProcessor, Configuration configuration, Locale locale, DefaultTransaction defaultTransaction, ff ff2, Profiler profiler, gV gV2, gv gv2, DelayConfig delayConfig) {
        super(transactionProcessor, configuration, locale, defaultTransaction, ff2, profiler, gV2, gv2);
        this.f = locale;
        this.e = new s(this.d);
        this.g = delayConfig;
    }

    @Override
    protected void internalStart() {
        this.paymentTextDisplayerHelper.a((PaymentAccessory)this.transaction.getAccessory(), LocalizationPrompt.PROCESSING_TRANSACTION, null, this.transaction.getType(), new String[0]);
        String cfr_ignored_0 = "Starting workflow with transaction type " + this.transaction.getType();
        this.transaction.getAccessory().getDisplayModule().cancelDisplayIdleScreenAfterTimeout();
        this.a(true);
    }

    @Override
    public void returnApproved() {
        this.transaction.propagateStateChange(TransactionState.ENDED);
        super.returnApproved();
    }

    @Override
    public void returnFailure(MposError error) {
        this.transaction.propagateStateChange(TransactionState.ENDED);
        super.returnFailure(error);
    }

    private void a(boolean bl2) {
        String.format("displayCardPrompt, firstTime: '%s'", bl2);
        AbstractPaymentAccessory abstractPaymentAccessory = this.transaction.getAccessory();
        LocalizationPrompt localizationPrompt = bl2 ? LocalizationPrompt.SWIPE_CARD : LocalizationPrompt.CARD_NOT_SUPPORTED_MAGSTRIPE;
        String[] stringArray = this.a();
        Task.delay((long)this.g.getGiftCardTransactionDelay()).continueWith(task -> {
            this.transaction.propagateStateChange(TransactionState.AWAITING_CARD);
            this.paymentTextDisplayerHelper.a(abstractPaymentAccessory, GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.b(), (accessory, mposError) -> {
                this.transaction.setError(mposError);
                this.errorTransaction();
            }), localizationPrompt, this.transaction.getType(), this.transaction.getWorkflow(), this.transaction.getAmount(), this.transaction.getCurrency(), stringArray);
            return null;
        });
    }

    private String[] a() {
        String[] stringArray = new String[]{null};
        if (this.transaction.getCurrency() != null && this.transaction.getAmount() != null) {
            String string = new CurrencyWrapper(this.transaction.getCurrency(), this.f).formatAmountAndCurrency(this.transaction.getAmount());
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    private void b() {
        ProcessingOnDeviceMeasurement.reportBegin(this.getProfiler(), "GiftCardTransactionWorkflow");
        this.transaction.getAccessory().getCardProcessingModule().detectCardOnInterface(EnumSet.of(AbstractCardProcessingModule.ActiveInterface.MAGSTRIPE), EnumSet.of(AbstractCardProcessingModule.CardProcessingTrait.OPT_OUT_AVAILABLE), new CardProcessingDetectCardListener(){

            @Override
            public void success(PaymentAccessory accessory, AbstractCardProcessingModule.CardType cardType, MagstripeInformation magstripeInformation) {
                fE.this.a(magstripeInformation);
            }

            @Override
            public void failure(PaymentAccessory accessory, MposError error) {
                ProcessingOnDeviceMeasurement.reportEndWithError(fE.this.getProfiler(), "failed", fE.this.transaction);
                fE.this.transaction.setError(error);
                fE.this.errorTransaction();
            }

            @Override
            public void cancel(PaymentAccessory accessory, AbstractCardProcessingModule.CancelReason cancelReason) {
                ProcessingOnDeviceMeasurement.reportEnd(fE.this.getProfiler(), "cancel");
                if (cancelReason == AbstractCardProcessingModule.CancelReason.USER_OPTED_OUT) {
                    fE.this.c();
                    return;
                }
                fE.this.a(cancelReason);
            }
        });
    }

    private void c() {
        this.transaction.propagateStateChange(TransactionState.AWAITING_CARD_DATA_INPUT);
        AskForCardDataParameters askForCardDataParameters = new AskForCardDataParameters.Builder(new CardDataPrompt[]{CardDataPrompt.CARD_NUMBER}).showIdleScreen().withTransactionWorkflowType(TransactionWorkflowType.GIFT_CARD).withTransactionType(this.transaction.getType()).build();
        ProcessingOnDeviceMeasurement.reportBegin(this.getProfiler(), "GiftCardTransactionWorkflow");
        InteractionComponent interactionComponent = (InteractionComponent)this.transaction.getAccessory().getAccessoryComponent(AccessoryComponentType.INTERACTION);
        interactionComponent.askForCardDataWithParameters(askForCardDataParameters, new AskForCardDataListener(){

            @Override
            public void success(CardData result) {
                ProcessingOnDeviceMeasurement.reportEnd(fE.this.getProfiler(), "approved");
                fE.this.a(result);
            }

            @Override
            public void aborted(AbortReason reason) {
                ProcessingOnDeviceMeasurement.reportEnd(fE.this.getProfiler(), "cancel");
                switch (reason) {
                    case TIMED_OUT: {
                        fE.this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_PRESENT_CARD_TIMED_OUT);
                        return;
                    }
                    case USER_ABORTED: {
                        fE.this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
                        return;
                    }
                }
            }

            @Override
            public void failure(MposError error) {
                ProcessingOnDeviceMeasurement.reportEndWithError(fE.this.getProfiler(), "failed", fE.this.transaction);
                fE.this.errorTransaction(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR, error);
            }
        });
    }

    private void a(CardData cardData) {
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setWorkflowType(TransactionWorkflowType.GIFT_CARD);
        defaultPaymentDetails.setScheme(PaymentDetailsScheme.VALUE_LINK);
        defaultPaymentDetails.setSource(PaymentDetailsSource.MANUAL);
        defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.NONE);
        PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
        paymentDetailsManualInputWrapper.setCardData(new DefaultCardData(cardData.getSred(), cardData.getKsn(), cardData.getMaskedPan()));
        if (paymentDetailsManualInputWrapper.isCardDataValid()) {
            this.transaction.setPaymentDetails(defaultPaymentDetails);
            this.d();
        } else {
            this.voidTransaction(TransactionStatusDetailsCodes.DECLINED_CARD_INVALID_PAN);
        }
    }

    private void a(MagstripeInformation magstripeInformation) {
        DefaultPaymentDetails defaultPaymentDetails = new DefaultPaymentDetails();
        defaultPaymentDetails.setWorkflowType(TransactionWorkflowType.GIFT_CARD);
        defaultPaymentDetails.setSource(PaymentDetailsSource.MAGNETIC_STRIPE);
        defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.NONE);
        PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
        paymentDetailsMagstripeWrapper.setMagstripeInformation(magstripeInformation);
        defaultPaymentDetails.setScheme(CardHelper.schemeForAccountNumber(magstripeInformation.getMaskedAccountNumber(), true));
        paymentDetailsMagstripeWrapper.setSchemeName(PaymentDetailsSchemesContainer.schemeNameForScheme(defaultPaymentDetails.getScheme()));
        if (defaultPaymentDetails.getScheme() == PaymentDetailsScheme.VALUE_LINK) {
            ProcessingOnDeviceMeasurement.reportEnd(this.getProfiler(), "approved");
            this.transaction.setPaymentDetails(defaultPaymentDetails);
            this.d();
        } else {
            ProcessingOnDeviceMeasurement.reportEnd(this.getProfiler(), "card not supported");
            this.a(false);
        }
    }

    private void d() {
        if (this.e()) {
            this.f();
        } else {
            this.g();
        }
    }

    private boolean e() {
        switch (this.transaction.getType()) {
            case CHARGE: 
            case CASHOUT: {
                return true;
            }
        }
        return false;
    }

    private void f() {
        InteractionComponent interactionComponent = (InteractionComponent)this.transaction.getAccessory().getAccessoryComponent(AccessoryComponentType.INTERACTION);
        AskForNumberInteractionParameters askForNumberInteractionParameters = new AskForNumberInteractionParameters.Builder(InteractionPrompt.ENTER_EAN, InteractionPrompt.EMPTY).maximumNumberOfDigits((byte)8).minimumNumberOfDigits((byte)1).build();
        ProcessingOnDeviceMeasurement.reportBegin(this.getProfiler(), "GiftCardTransactionWorkflow");
        interactionComponent.askForNumber(askForNumberInteractionParameters, new AskForNumberListener(){

            @Override
            public void success(String ean) {
                ProcessingOnDeviceMeasurement.reportEnd(fE.this.getProfiler(), "approved");
                fE.this.a(ean);
            }

            @Override
            public void aborted(AbortReason abortReason) {
                ProcessingOnDeviceMeasurement.reportEnd(fE.this.getProfiler(), "cancel");
                switch (abortReason) {
                    case TIMED_OUT: {
                        fE.this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_PRESENT_CARD_TIMED_OUT);
                        break;
                    }
                    case USER_ABORTED: {
                        fE.this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
                    }
                }
            }

            @Override
            public void failure(MposError error) {
                ProcessingOnDeviceMeasurement.reportEndWithError(fE.this.getProfiler(), "failed", fE.this.transaction);
                fE.this.errorTransaction(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR, error);
            }

            @Override
            public void skip() {
                Log.e(fE.this.d, "Skip not implemented");
                this.aborted(AbortReason.USER_ABORTED);
            }
        });
    }

    private void a(String string) {
        this.b(string);
        this.g();
    }

    private void b(String string) {
        String string2 = string != null && !string.isEmpty() ? string : null;
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)this.transaction.getPaymentDetails();
        PaymentDetailsManualInputWrapper paymentDetailsManualInputWrapper = new PaymentDetailsManualInputWrapper(defaultPaymentDetails);
        PaymentDetailsMagstripeWrapper paymentDetailsMagstripeWrapper = new PaymentDetailsMagstripeWrapper(defaultPaymentDetails);
        if (defaultPaymentDetails.sourceHasManualData()) {
            paymentDetailsManualInputWrapper.setSecurityCode(string2);
        } else {
            paymentDetailsMagstripeWrapper.setSecurityCode(string2);
        }
    }

    private void g() {
        this.getProfiler().beginMeasurement(Profiler.Category.TRANSACTION_PROCESSING_EXECUTE, "starting execute fragment for transaction");
        this.updateInternalWorkflowState(PaymentWorkflowState.IN_PAYMENT);
        this.transaction.propagateStateChange(TransactionState.AWAITING_EXECUTION);
        this.workflowFragment = this.getFragmentFactory().a(this.transaction, (fW)this, this.transactionProcessor, new fL(){

            @Override
            public void a() {
                fE.this.a("transaction approved", fE.this.transaction);
                fE.this.i();
            }

            @Override
            public void b() {
                fE.this.a("transaction is pending", fE.this.transaction);
                fE.this.voidTransaction();
            }

            @Override
            public void c() {
                fE.this.a("transaction declined", fE.this.transaction);
                fE.this.h();
            }

            @Override
            public void a(MposError mposError) {
                fE.this.a("transaction is unable to go online", fE.this.transaction);
                fE.this.errorTransaction(mposError);
            }

            @Override
            public void b(MposError mposError) {
                fE.this.a("transaction failed", fE.this.transaction);
                fE.this.errorTransaction(mposError);
            }

            @Override
            public void a(DefaultTransaction defaultTransaction, DefaultTransaction defaultTransaction2) {
            }
        });
        this.workflowFragment.a();
    }

    private void h() {
        this.transaction.propagateStateChange(TransactionState.AWAITING_COMPLETION);
        LocalizationPrompt localizationPrompt2 = LocalizationPrompt.COMPLETED_WITH_STATUS;
        TransactionStatusDetailsCodes transactionStatusDetailsCodes = this.transaction.getStatusDetails().getCode();
        this.paymentTextDisplayerHelper.a((PaymentAccessory)this.transaction.getAccessory(), GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.returnFailure(this.transaction.getError()), (accessory, mposError) -> this.returnFailure(mposError)), localizationPrompt2, transactionStatusDetailsCodes, this.transaction.getType(), this.transaction.getWorkflow(), this.transaction.getAmount(), this.transaction.getCurrency());
    }

    private void i() {
        this.transaction.propagateStateChange(TransactionState.AWAITING_COMPLETION);
        BigDecimal bigDecimal = null;
        Currency currency = this.transaction.getGiftCardDetails().getCurrency();
        switch (this.transaction.getType()) {
            case ACTIVATION: {
                currency = this.transaction.getCurrency();
                bigDecimal = this.transaction.getAmount();
                break;
            }
            case BALANCE_INQUIRY: {
                bigDecimal = this.transaction.getGiftCardDetails().getCurrentBalance();
                currency = this.transaction.getGiftCardDetails().getCurrency();
            }
            case CHARGE: {
                if (this.transaction.getStatus() != TransactionStatus.APPROVED) break;
                if (this.transaction.getStatusDetails().getCode() == TransactionStatusDetailsCodes.APPROVED_PARTIALLY) {
                    bigDecimal = this.transaction.getAmount();
                    break;
                }
                bigDecimal = this.transaction.getGiftCardDetails().getCurrentBalance();
                break;
            }
            case CASHOUT: {
                bigDecimal = this.transaction.getGiftCardDetails().getPreviousBalance();
            }
        }
        String string = new CurrencyWrapper(currency, this.f).formatAmountAndCurrency(bigDecimal);
        String[] stringArray = new String[]{string};
        this.paymentTextDisplayerHelper.a((PaymentAccessory)this.transaction.getAccessory(), GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((accessory, localizationPrompt) -> this.returnApproved(), (accessory, mposError) -> this.returnFailure(this.transaction.getError())), LocalizationPrompt.COMPLETED_WITH_STATUS, this.transaction.getStatusDetails().getCode(), this.transaction.getType(), this.transaction.getWorkflow(), this.transaction.getAmount(), this.transaction.getCurrency(), stringArray);
    }

    private void a(AbstractCardProcessingModule.CancelReason cancelReason) {
        switch (cancelReason) {
            case CARD_REMOVED: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_REMOVED_CARD);
                return;
            }
            case USER_CANCELED: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
                return;
            }
            case UNKNOWN: {
                Log.w(this.d, "cancelReason == UNKNOWN");
                this.abortTransaction();
            }
        }
    }

    private void a(String string, BaseTransaction baseTransaction) {
        this.getProfiler().endMeasurement(Profiler.Category.TRANSACTION_PROCESSING_EXECUTE, string + ", status: '" + baseTransaction.getStatus() + "'");
    }
}

