/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.core.common.obfuscated;

import io.mpos.accessories.Accessory;
import io.mpos.accessories.AccessoryConnectionState;
import io.mpos.accessories.components.interaction.AbortReason;
import io.mpos.accessories.payment.PaymentAccessory;
import io.mpos.core.common.obfuscated.cD;
import io.mpos.core.common.obfuscated.eU;
import io.mpos.core.common.obfuscated.eo;
import io.mpos.core.common.obfuscated.ew;
import io.mpos.core.common.obfuscated.ex;
import io.mpos.core.common.obfuscated.fG;
import io.mpos.core.common.obfuscated.fJ;
import io.mpos.core.common.obfuscated.fL;
import io.mpos.core.common.obfuscated.fM;
import io.mpos.core.common.obfuscated.ff;
import io.mpos.core.common.obfuscated.ft;
import io.mpos.core.common.obfuscated.gG;
import io.mpos.core.common.obfuscated.gV;
import io.mpos.core.common.obfuscated.ga;
import io.mpos.core.common.obfuscated.gv;
import io.mpos.core.common.obfuscated.ha;
import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.logger.Log;
import io.mpos.paymentdetails.PaymentDetails;
import io.mpos.paymentdetails.PaymentDetailsScheme;
import io.mpos.platform.AbstractImageHelper;
import io.mpos.shared.accessories.modules.AbstractCardProcessingModule;
import io.mpos.shared.accessories.modules.listener.CardProcessingContinueTransactionListener;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessFailureListenerFactory;
import io.mpos.shared.accessories.modules.listener.GenericOperationSuccessListener;
import io.mpos.shared.accessories.modules.listener.LanguageSelectionListener;
import io.mpos.shared.accessories.modules.listener.LanguageSwitchListener;
import io.mpos.shared.accessories.payment.AbstractPaymentAccessory;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.events.BusProvider;
import io.mpos.shared.events.providercomponent.TransactionStateChangedBusEvent;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.localization.LocalizationPrompt;
import io.mpos.shared.localization.LocalizationServer;
import io.mpos.shared.paymentdetails.DefaultPaymentDetails;
import io.mpos.shared.paymentdetails.PaymentDetailsCustomerVerificationDetailed;
import io.mpos.shared.paymentdetails.PaymentDetailsFallbackReason;
import io.mpos.shared.processors.OnlineTransactionProcessor;
import io.mpos.shared.processors.TransactionProcessor;
import io.mpos.shared.provider.ProcessingOptions;
import io.mpos.shared.provider.ProcessingOptionsContainer;
import io.mpos.shared.provider.configuration.Configuration;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.shared.transactions.CurrencyWrapper;
import io.mpos.shared.transactions.DefaultTransaction;
import io.mpos.shared.workflows.PaymentWorkflowState;
import io.mpos.shared.workflows.evaluator.AidEvaluator;
import io.mpos.shared.workflows.evaluator.LanguageEvaluationResult;
import io.mpos.shared.workflows.evaluator.LanguageEvaluator;
import io.mpos.transactions.TransactionAction;
import io.mpos.transactions.TransactionState;
import io.mpos.transactions.TransactionStatus;
import io.mpos.transactions.TransactionStatusDetailsCodes;
import io.mpos.transactions.actionresponse.TransactionActionResponse;
import io.mpos.transactions.actionsupport.TransactionActionSupport;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public abstract class fW
extends ew
implements ex {
    private static final String TAG = "PaymentWorkflow";
    private PaymentWorkflowState state = PaymentWorkflowState.PREPAYMENT;
    @NotNull
    protected DefaultTransaction transaction;
    protected TransactionProcessor transactionProcessor;
    protected ga transactionListener;
    protected fJ abortListener;
    protected ft workflowFragment;
    protected AbstractImageHelper abstractImageHelper;
    private Configuration configuration;
    @NotNull
    private Locale locale;
    private eU aidEvaluatorFactory;
    protected gV paymentTextDisplayer;
    protected gv paymentTextDisplayerHelper;

    public fW(TransactionProcessor transactionProcessor, Configuration configuration, Locale locale, DefaultTransaction defaultTransaction, ff ff2, AbstractImageHelper abstractImageHelper, Profiler profiler, gV gV2, gv gv2) {
        super(ff2, profiler);
        this.paymentTextDisplayer = gV2;
        this.paymentTextDisplayerHelper = gv2;
        this.init(transactionProcessor, configuration, locale, defaultTransaction);
        this.abstractImageHelper = abstractImageHelper;
    }

    public fW(TransactionProcessor transactionProcessor, Configuration configuration, Locale locale, DefaultTransaction defaultTransaction, ff ff2, Profiler profiler, gV gV2, gv gv2) {
        this(transactionProcessor, configuration, locale, defaultTransaction, ff2, null, profiler, gV2, gv2);
    }

    private void init(TransactionProcessor transactionProcessor, Configuration configuration, Locale locale, DefaultTransaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("The transaction must not be null");
        }
        this.transaction = transaction;
        this.transactionProcessor = transactionProcessor;
        this.configuration = configuration;
        this.locale = locale;
        this.aidEvaluatorFactory = new eU(configuration.getProcessingOptionsContainer());
    }

    public TransactionProcessor getTransactionProcessor() {
        return this.transactionProcessor;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public boolean canBeAborted() {
        return this.getState() == PaymentWorkflowState.PREPAYMENT;
    }

    @Override
    public void start(ga listener) {
        this.transactionListener = listener;
        this.verifyAndResetTerminalLanguage(this::continueWithTransaction);
    }

    private void continueWithTransaction() {
        try {
            this.internalStart();
        }
        catch (Exception exception) {
            this.getProfiler().event(Profiler.Category.TRANSACTION_PROCESSING_ERROR, "Unknown Error in Abstract Payment Workflow " + exception.getMessage());
            this.returnFailure(new DefaultMposError(exception));
        }
    }

    protected void verifyAndResetTerminalLanguage(final Runnable runAfter) {
        AbstractPaymentAccessory abstractPaymentAccessory = this.transaction.getAccessory();
        if (abstractPaymentAccessory == null || abstractPaymentAccessory.getConnectionState() != AccessoryConnectionState.CONNECTED) {
            Log.w(TAG, "Skipping reset of terminal language due to disconnected accessory");
            runAfter.run();
            return;
        }
        LanguageSwitchListener languageSwitchListener = new LanguageSwitchListener(){

            public void a() {
                runAfter.run();
            }

            public void b() {
                runAfter.run();
            }

            @Override
            public /* synthetic */ void onOperationSuccess(Object object, Object object2) {
                Accessory cfr_ignored_0 = (Accessory)object;
                Locale cfr_ignored_1 = (Locale)object2;
                this.b();
            }

            @Override
            public /* synthetic */ void onOperationFailure(Object object, MposError mposError) {
                Accessory cfr_ignored_0 = (Accessory)object;
                this.a();
            }
        };
        if (abstractPaymentAccessory.isLanguageSwitchSupported(this.getLocale())) {
            abstractPaymentAccessory.getDisplayModule().switchTerminalAndPromptsLanguage(this.getLocale(), languageSwitchListener);
        } else {
            abstractPaymentAccessory.getDisplayModule().setTerminalLanguage(Locale.ENGLISH, languageSwitchListener);
        }
    }

    protected abstract void internalStart();

    @Override
    public void requestAction(TransactionAction action, TransactionActionSupport support) {
        this.transactionListener.onTransactionActionRequired(this.transaction, action, support);
    }

    @Override
    public void continueWithAction(TransactionAction action, TransactionActionResponse response) {
        this.internalDistributeToModules(action, response);
        if (this.workflowFragment != null) {
            this.workflowFragment.a(action, response);
        }
    }

    protected void internalDistributeToModules(TransactionAction action, TransactionActionResponse response) {
        AbstractPaymentAccessory abstractPaymentAccessory = this.transaction.getAccessory();
        abstractPaymentAccessory.getInteractionModule().continueWithAction(action, response);
        abstractPaymentAccessory.getDisplayModule().continueWithAction(action, response);
    }

    @Override
    public void abort(fJ listener) {
        this.abortListener = listener;
        if (this.getState() != PaymentWorkflowState.PREPAYMENT) {
            this.returnAbortFailure(new DefaultMposError(ErrorType.TRANSACTION_NO_LONGER_ABORTABLE));
            return;
        }
        if (this.getState() == PaymentWorkflowState.ABORT) {
            this.returnAbortFailure(new DefaultMposError(ErrorType.TRANSACTION_NO_LONGER_ABORTABLE));
            return;
        }
        this.updateInternalWorkflowState(PaymentWorkflowState.ABORT);
        if (this.workflowFragment != null) {
            this.workflowFragment.a_();
        }
        this.transaction.getAccessory().resetModules();
        this.internalAbortTransactionTriggeredByIntegrator();
    }

    @Override
    public void abortAsResultOfAccessoryDisconnect() {
        if (this.transaction.getStatus() == TransactionStatus.APPROVED || this.transaction.getStatus() == TransactionStatus.ACCEPTED) {
            this.updateInternalWorkflowState(PaymentWorkflowState.POST_PAYMENT);
            this.transaction.propagateStateChange(TransactionState.AWAITING_COMPLETION);
            this.returnApproved();
        } else {
            this.updateInternalWorkflowState(PaymentWorkflowState.ABORT);
            if (this.workflowFragment != null) {
                this.workflowFragment.a_();
            }
            this.internalAbortTransactionAsResultOfAccessoryDisconnect();
        }
    }

    public void voidTransaction(TransactionStatusDetailsCodes code) {
        this.transaction.setStatus(TransactionStatus.DECLINED);
        this.transaction.getStatusDetails().setCode(code);
        this.voidTransaction();
    }

    public void voidTransaction() {
        if (this.transaction.getStatus() != TransactionStatus.DECLINED) {
            this.transaction.setStatus(TransactionStatus.DECLINED);
            this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.DECLINED_CARD_OR_TERMINAL_DECLINED);
        }
        this.workflowFragment = this.getFragmentFactory().c(this.transaction, this, this.getTransactionProcessor(), new fL(){

            @Override
            public void d() {
                fW.this.returnFailure(fW.this.transaction.getError());
            }

            @Override
            public void a() {
                fW.this.returnApproved();
            }

            @Override
            public void b(MposError mposError) {
                if (eo.b(mposError)) {
                    fW.this.transaction.setStatus(TransactionStatus.INCONCLUSIVE);
                }
                fW.this.transaction.setError(mposError);
                fW.this.returnFailure(mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void errorTransaction(MposError error) {
        TransactionStatusDetailsCodes transactionStatusDetailsCodes = eo.a(error.getErrorType(), this.transaction.getStatusDetails().getCode());
        this.errorTransaction(transactionStatusDetailsCodes, error);
    }

    public void errorTransaction(TransactionStatusDetailsCodes code, MposError error) {
        this.transaction.setStatus(TransactionStatus.ERROR);
        this.transaction.getStatusDetails().setCode(code);
        this.transaction.setError(error);
        this.errorTransaction();
    }

    public void errorTransaction() {
        if (this.transaction.getStatus() != TransactionStatus.ERROR) {
            this.transaction.setStatus(TransactionStatus.ERROR);
            this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR);
        }
        if (this.transaction.getProvider() == null) {
            return;
        }
        this.workflowFragment = this.fragmentFactory.e(this.transaction, this, this.transactionProcessor, new fL(){

            @Override
            public void d() {
                fW.this.returnFailure(fW.this.transaction.getError());
            }

            @Override
            public void a() {
                fW.this.returnApproved();
            }

            @Override
            public void b(MposError mposError) {
                if (eo.b(mposError)) {
                    fW.this.transaction.setStatus(TransactionStatus.INCONCLUSIVE);
                }
                fW.this.transaction.setError(mposError);
                fW.this.returnFailure(mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void abortTransaction(TransactionStatusDetailsCodes code) {
        if (this.getState() == PaymentWorkflowState.ABORT) {
            return;
        }
        this.transaction.setStatus(TransactionStatus.ABORTED);
        this.transaction.getStatusDetails().setCode(code);
        this.abortTransaction();
    }

    public void abortTransaction() {
        if (this.getState() == PaymentWorkflowState.ABORT) {
            return;
        }
        this.updateInternalWorkflowState(PaymentWorkflowState.ABORT);
        if (this.transaction.getStatus() != TransactionStatus.ABORTED) {
            this.transaction.setStatus(TransactionStatus.ABORTED);
            this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
        }
        if (this.transaction.getProvider() == null) {
            return;
        }
        this.workflowFragment = this.fragmentFactory.d(this.transaction, this, this.transactionProcessor, new fL(){

            @Override
            public void d() {
                fW.this.returnFailure(fW.this.transaction.getError());
            }

            @Override
            public void a() {
                fW.this.returnApproved();
            }

            @Override
            public void b(MposError mposError) {
                if (eo.b(mposError)) {
                    fW.this.transaction.setStatus(TransactionStatus.INCONCLUSIVE);
                }
                fW.this.transaction.setError(mposError);
                fW.this.returnFailure(mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void internalAbortTransactionTriggeredByIntegrator() {
        this.internalAbortTransactionTriggeredByIntegrator_onDevice();
    }

    protected void internalAbortTransactionTriggeredByIntegrator_onDevice() {
        this.workflowFragment = this.fragmentFactory.a(this.transaction, this, new fL(){

            @Override
            public void d() {
                fW.this.internalAbortTransactionTriggeredByIntegrator_atGateway();
            }

            @Override
            public void b(MposError mposError) {
                fW.this.internalAbortTransactionTriggeredByIntegrator_atGateway();
            }
        });
        this.workflowFragment.a();
    }

    public void internalAbortTransactionTriggeredByIntegrator_atGateway() {
        this.transaction.setStatus(TransactionStatus.ABORTED);
        this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ABORTED_MERCHANT_ABORTED);
        this.workflowFragment = this.fragmentFactory.d(this.transaction, this, this.transactionProcessor, new fL(){

            @Override
            public void d() {
                fW.this.returnFailure(new DefaultMposError(ErrorType.TRANSACTION_ABORTED));
                fW.this.returnAbortSuccess();
            }

            @Override
            public void a() {
                fW.this.returnApproved();
                fW.this.returnAbortFailure(new DefaultMposError(ErrorType.TRANSACTION_SESSION_EXPIRED));
            }

            @Override
            public void b(MposError mposError) {
                if (eo.b(mposError)) {
                    fW.this.transaction.setStatus(TransactionStatus.INCONCLUSIVE);
                }
                fW.this.transaction.setError(mposError);
                fW.this.returnFailure(mposError);
                fW.this.returnAbortFailure(mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void internalAbortTransactionAsResultOfAccessoryDisconnect() {
        this.transaction.setStatus(TransactionStatus.ERROR);
        this.transaction.getStatusDetails().setCode(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR);
        this.workflowFragment = this.fragmentFactory.f(this.transaction, this, this.transactionProcessor, new fL(){

            @Override
            public void d() {
                fW.this.returnFailure(new DefaultMposError(ErrorType.ACCESSORY_ERROR, "accessory disconnected"));
            }

            @Override
            public void a() {
                fW.this.returnApproved();
            }

            @Override
            public void b(MposError mposError) {
                if (eo.b(mposError)) {
                    fW.this.transaction.setStatus(TransactionStatus.INCONCLUSIVE);
                    fW.this.returnFailure(mposError);
                } else if (mposError.getErrorType() == ErrorType.TRANSACTION_REVERSAL_SCHEDULED) {
                    fW.this.returnFailure(mposError);
                } else {
                    fW.this.returnFailure(new DefaultMposError(ErrorType.ACCESSORY_ERROR, "accessory disconnected"));
                }
            }
        });
        this.workflowFragment.a();
    }

    public void returnApproved() {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.transaction.getAccessory() != null) {
                this.transaction.getAccessory().resetModules();
            }
            if (this.transactionListener != null) {
                this.transactionListener.onTransactionApproved(this.transaction);
            }
        });
    }

    public void returnFailure(MposError error) {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.transaction.getAccessory() != null) {
                this.transaction.getAccessory().resetModules();
            }
            if (this.transactionListener != null) {
                this.transactionListener.onTransactionFailure(this.transaction, error);
            }
        });
    }

    public void returnFallback(ha state) {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.transactionListener != null) {
                this.transactionListener.onTransactionFallback(this.transaction, state);
            }
        });
    }

    public void returnAlternativeCardPresented(PaymentDetails details) {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.transactionListener != null) {
                this.transactionListener.onTransactionAlternativeCardPresented(details);
            }
        });
    }

    public void returnAbortSuccess() {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.abortListener != null) {
                this.abortListener.success();
            }
        });
    }

    protected void returnAbortFailure(MposError error) {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.abortListener != null) {
                this.abortListener.failure(error);
            }
        });
    }

    public void returnStartOver() {
        this.verifyAndResetTerminalLanguage(() -> {
            if (this.transactionListener != null) {
                this.transactionListener.onTransactionStartOver(this.transaction);
            }
        });
    }

    public PaymentWorkflowState getState() {
        return this.state;
    }

    public void updateInternalWorkflowState(PaymentWorkflowState state, TransactionState transactionState) {
        this.transaction.propagateStateChange(transactionState);
        this.updateInternalWorkflowState(state);
    }

    public void updateInternalWorkflowState(PaymentWorkflowState state) {
        boolean bl2 = this.canBeAborted();
        this.state = state;
        if (bl2 != this.canBeAborted()) {
            BusProvider.getInstance().post((Object)new TransactionStateChangedBusEvent(this.transaction, this.transaction.getState(), this.canBeAborted()));
        }
    }

    public void step3_1_execute(@NotNull fL executeListener) {
        this.updateInternalWorkflowState(PaymentWorkflowState.IN_PAYMENT);
        this.workflowFragment = this.fragmentFactory.a(this.transaction, this, this.transactionProcessor, executeListener);
        this.workflowFragment.a();
    }

    public void step3_1_execute() {
        this.step3_1_execute(new fL(){

            @Override
            public void a() {
                fW.this.step3_2_executeOnAccessory(true);
            }

            @Override
            public void b() {
                fW.this.step3_2_executeOnAccessory(true);
            }

            @Override
            public void c() {
                fW.this.step3_2_executeOnAccessory(true);
            }

            @Override
            public void a(MposError mposError) {
                if (fW.this.transaction != null) {
                    fW.this.transaction.setError(mposError);
                }
                fW.this.step3_2_executeOnAccessory(false);
            }

            @Override
            public void a(DefaultTransaction defaultTransaction, DefaultTransaction defaultTransaction2) {
            }

            @Override
            public void b(MposError mposError) {
                fW.this.step3_2_executeOnAccessory(mposError);
            }
        });
    }

    protected void step3_2_executeOnAccessory(MposError error) {
        this.transaction.setStatus(TransactionStatus.ERROR);
        this.transaction.setError(error);
        this.step3_2_executeOnAccessory(false);
    }

    public void step3_2_executeOnAccessory(boolean onlineDialogSuccessful) {
        this.transaction.setUnableToGoOnline(!onlineDialogSuccessful);
        this.workflowFragment = this.fragmentFactory.c(this.transaction, this, onlineDialogSuccessful, new fL(){

            @Override
            public void d() {
            }

            @Override
            public void b(MposError mposError) {
                fW.this.errorTransaction(TransactionStatusDetailsCodes.ERROR_TERMINAL_ERROR, mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void step4_signature(@NotNull fM verificationListener, @NotNull fL failureListener) {
        this.updateInternalWorkflowState(PaymentWorkflowState.POST_PAYMENT);
        this.applyServerBasedCvmRequirement();
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)this.transaction.getPaymentDetails();
        if (!defaultPaymentDetails.requiresSignature()) {
            this.step5_identification();
            return;
        }
        this.workflowFragment = this.fragmentFactory.a(this.transaction, this, this.abstractImageHelper, verificationListener, failureListener);
        this.workflowFragment.a();
    }

    public void step4_signature() {
        this.step4_signature(verified -> {
            if (verified) {
                this.step5_identification();
            } else {
                this.transaction.setError(new DefaultMposError(ErrorType.TRANSACTION_ABORTED, "transaction aborted by merchant"));
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_MERCHANT_ABORTED);
            }
        }, new fL(){

            @Override
            public void b(MposError mposError) {
                fW.this.voidTransaction();
            }
        });
    }

    public void createRequestSignatureFragment(fM successListener, fL listener) {
        this.workflowFragment = this.fragmentFactory.a(this.transaction, this, this.abstractImageHelper, successListener, listener);
        this.workflowFragment.a();
    }

    private void step5_identification() {
        this.updateInternalWorkflowState(PaymentWorkflowState.POST_PAYMENT);
        if (!gG.b(this.transaction)) {
            this.step6_finalize();
            return;
        }
        this.workflowFragment = this.fragmentFactory.a(this.transaction, this, verified -> {
            if (verified) {
                this.step6_finalize();
            } else {
                this.voidTransaction(TransactionStatusDetailsCodes.DECLINED_CARD_OR_TERMINAL_DECLINED);
            }
        }, new fL(){

            @Override
            public void b(MposError mposError) {
                fW.this.voidTransaction();
            }
        });
        this.workflowFragment.a();
    }

    public void step6_finalize() {
        this.updateInternalWorkflowState(PaymentWorkflowState.POST_PAYMENT);
        this.workflowFragment = this.fragmentFactory.b(this.transaction, this, this.transactionProcessor, new fL(){

            @Override
            public void a() {
                fW.this.returnApproved();
            }

            @Override
            public void c() {
                fW.this.returnFailure(fW.this.transaction.getError());
            }

            @Override
            public void b(MposError mposError) {
                fW.this.errorTransaction(mposError);
            }
        });
        this.workflowFragment.a();
    }

    public void applyServerBasedCvmRequirement() {
        ProcessingOptionsContainer processingOptionsContainer = this.configuration.getProcessingOptionsContainer();
        DefaultPaymentDetails defaultPaymentDetails = (DefaultPaymentDetails)this.transaction.getPaymentDetails();
        if (processingOptionsContainer == null || processingOptionsContainer.shouldUseDefaultCvm(defaultPaymentDetails.getScheme(), defaultPaymentDetails.getSource())) {
            String cfr_ignored_0 = "Server requires DEFAULT CVM for scheme " + defaultPaymentDetails.getScheme() + " using source " + defaultPaymentDetails.getSource();
            return;
        }
        ProcessingOptions processingOptions = processingOptionsContainer.getProcessingOptions(defaultPaymentDetails.getScheme(), defaultPaymentDetails.getSource());
        ProcessingOptions.CVM cVM = processingOptions.getCvm();
        String cfr_ignored_1 = "Server forces " + cVM + " as CVM for scheme " + defaultPaymentDetails.getScheme() + " using source " + defaultPaymentDetails.getSource();
        switch (cVM) {
            case NONE: {
                defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.NONE);
                break;
            }
            case PIN: {
                defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.PIN_ONLINE);
                break;
            }
            case SIGNATURE: {
                defaultPaymentDetails.setCustomerVerificationDetailed(PaymentDetailsCustomerVerificationDetailed.SIGNATURE);
                break;
            }
            case DEFAULT: {
                String cfr_ignored_2 = "cannot force CVM to " + cVM + ", using DEFAULT one for now";
            }
        }
    }

    public void handleEmvError(AbstractCardProcessingModule.EmvErrorType errorType, AbstractCardProcessingModule.FallbackStatus fallbackStatus) {
        if (fallbackStatus == AbstractCardProcessingModule.FallbackStatus.ALLOWED) {
            ((DefaultPaymentDetails)this.transaction.getPaymentDetails()).setFallback(true);
            PaymentDetailsFallbackReason paymentDetailsFallbackReason = this.fallbackReasonForEmvError(errorType);
            ((DefaultPaymentDetails)this.transaction.getPaymentDetails()).setFallbackReason(paymentDetailsFallbackReason);
            this.returnFallback(ha.f);
        } else {
            ((DefaultPaymentDetails)this.transaction.getPaymentDetails()).setFallback(false);
            ((DefaultPaymentDetails)this.transaction.getPaymentDetails()).setFallbackReason(PaymentDetailsFallbackReason.UNKNOWN);
            this.returnFallback(ha.a);
        }
    }

    public void handleCancelReason(AbstractCardProcessingModule.CancelReason cancelReason) {
        switch (cancelReason) {
            case CARD_REMOVED: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_REMOVED_CARD);
                break;
            }
            case USER_CANCELED: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
                break;
            }
            case NFC_TIMED_OUT: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_PRESENT_CARD_TIMED_OUT);
                break;
            }
            case PIN_TIMED_OUT: {
                this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_PIN_ENTRY_TIMED_OUT);
                break;
            }
            case TRACK_INVALID: {
                this.abortTransaction(TransactionStatusDetailsCodes.DECLINED_CARD_EMPTY_TRACK_DATA_MAGSTRIPE);
                break;
            }
            default: {
                this.abortTransaction();
            }
        }
    }

    protected PaymentDetailsFallbackReason fallbackReasonForEmvError(AbstractCardProcessingModule.EmvErrorType errorType) {
        switch (errorType) {
            case CARD_NOT_SUPPORTED: {
                return PaymentDetailsFallbackReason.CARD_NO_MATCHING_APPLICATION;
            }
            case UNKNOWN: 
            case INTERFACE_SWITCH_TO_ICC_REQUIRED: 
            case INTERFACE_SWITCH_TO_ICC_MSR_REQUIRED: 
            case CARD_NOT_RESPONDING: 
            case CARD_ICC_ERROR: {
                return PaymentDetailsFallbackReason.CARD_ERROR;
            }
        }
        return PaymentDetailsFallbackReason.CARD_ERROR;
    }

    @Deprecated
    protected String createAmountString() {
        AbstractPaymentAccessory abstractPaymentAccessory = this.transaction.getAccessory();
        if (!abstractPaymentAccessory.amountConfirmationRequired()) {
            return new CurrencyWrapper(this.transaction.getCurrency(), this.locale).formatAmountAndCurrency(this.transaction.getAmount());
        }
        return "";
    }

    @Deprecated
    protected void displayCompletedWithStatus(GenericOperationSuccessListener<Accessory, Void> listener) {
        this.transaction.propagateStateChange(TransactionState.AWAITING_COMPLETION);
        this.paymentTextDisplayerHelper.a((PaymentAccessory)this.transaction.getAccessory(), GenericOperationSuccessFailureListenerFactory.genericOperationSuccessFailureListener((operator, data) -> listener.onOperationSuccess((Accessory)operator, (Void)null), (operator, error) -> listener.onOperationSuccess((Accessory)operator, (Void)null)), LocalizationPrompt.COMPLETED_WITH_STATUS, this.transaction.getStatusDetails().getCode(), this.transaction.getType(), this.transaction.getWorkflow(), this.transaction.getAmount(), this.transaction.getCurrency());
    }

    public void handleIccWorkflowDccRequestAndContinue(PaymentAccessory paymentAccessory) {
        this.handleDcc(false, () -> paymentAccessory.getCardProcessingModule().continueTransactionWithDccSelection(this.transaction, new CardProcessingContinueTransactionListener(){

            @Override
            public void success(PaymentAccessory accessory, BaseTransaction transaction) {
            }

            @Override
            public void failure(PaymentAccessory accessory, BaseTransaction transaction, MposError error) {
            }
        }));
    }

    protected AidEvaluator getAidEvaluator() {
        return this.aidEvaluatorFactory.a(this.transaction);
    }

    protected boolean pinBypassAllowed() {
        return this.getConfiguration().getProcessingOptionsContainer().isFeatureEnabled(ProcessingOptions.Feature.PIN_ENTRY_BYPASS);
    }

    public boolean isSchemeDebitOrUnionPay() {
        PaymentDetailsScheme paymentDetailsScheme = this.transaction.getPaymentDetails().getScheme();
        return paymentDetailsScheme.isDebit() || paymentDetailsScheme.isUnionPayFamily();
    }

    public PaymentDetailsCustomerVerificationDetailed getCVMDetailed() {
        return ((DefaultPaymentDetails)this.transaction.getPaymentDetails()).getCustomerVerificationDetailed();
    }

    public LocalizationPrompt getCardRemovalPrompt(boolean includeStatus) {
        if (this.transaction.getStatusDetails().getCode().equals((Object)TransactionStatusDetailsCodes.DECLINED_FORBIDDEN_CARD_CAPTURE_CARD)) {
            return LocalizationPrompt.COMPLETED_WITH_STATUS;
        }
        if (includeStatus) {
            return LocalizationPrompt.REMOVE_CARD_WITH_STATUS;
        }
        return LocalizationPrompt.REMOVE_CARD;
    }

    protected EnumSet<ProcessingOptions.Behavior> getBehaviors() {
        return this.getConfiguration().getProcessingOptionsContainer().getAccessoryBehaviors();
    }

    public LocalizationPrompt getFinalPrompt() {
        if (cD.a(this.transaction)) {
            return LocalizationPrompt.PROVIDE_SIGNATURE_WITH_STATUS;
        }
        return LocalizationPrompt.COMPLETED_WITH_STATUS;
    }

    public void performShopperLanguageSwitch(List<Locale> cardPreferredLanguages, List<Locale> terminalLanguages, final PaymentAccessory paymentAccessory, final Runnable continueAction) {
        if (!this.getBehaviors().contains((Object)ProcessingOptions.Behavior.USE_SHOPPER_LANGUAGE_FOR_ACCESSORY_PROMPTS)) {
            continueAction.run();
            return;
        }
        if (this.transaction.getSelectedLanguage() != null) {
            this.switchLanguage(this.transaction.getSelectedLanguage(), paymentAccessory, continueAction);
            return;
        }
        LanguageEvaluationResult languageEvaluationResult = LanguageEvaluator.evaluate(cardPreferredLanguages, terminalLanguages, this.locale, this.getBehaviors());
        if (languageEvaluationResult.isLanguageSelected()) {
            Locale locale = languageEvaluationResult.getSelectedLanguage();
            this.switchLanguage(locale, paymentAccessory, continueAction);
        } else {
            paymentAccessory.getInteractionModule().requestLanguageSelection(this.obtainLocalesForLanguageSelection(terminalLanguages), new LanguageSelectionListener(){

                @Override
                public void aborted(AbortReason reason) {
                    if (reason == AbortReason.TIMED_OUT) {
                        continueAction.run();
                    } else {
                        fW.this.abortTransaction();
                    }
                }

                public void a(Locale locale) {
                    fW.this.transaction.setSelectedLanguage(locale);
                    fW.this.switchLanguage(locale, paymentAccessory, continueAction);
                }

                public void a() {
                    continueAction.run();
                }

                @Override
                public /* synthetic */ void onOperationSuccess(Object object, Object object2) {
                    Accessory cfr_ignored_0 = (Accessory)object;
                    this.a((Locale)object2);
                }

                @Override
                public /* synthetic */ void onOperationFailure(Object object, MposError mposError) {
                    Accessory cfr_ignored_0 = (Accessory)object;
                    this.a();
                }
            });
        }
    }

    private List<Locale> obtainLocalesForLanguageSelection(List<Locale> terminalLanguages) {
        if (this.shouldLimitLanguageList()) {
            return LocalizationServer.localesForInteracLanguageSelectionScreen;
        }
        return terminalLanguages;
    }

    private boolean shouldLimitLanguageList() {
        return this.getBehaviors().contains((Object)ProcessingOptions.Behavior.LIMIT_LANGUAGES_LIST_FOR_INTERAC_LANGUAGE_SELECTION);
    }

    private void switchLanguage(Locale selectedLanguage, PaymentAccessory paymentAccessory, final Runnable continueAction) {
        paymentAccessory.getDisplayModule().switchTerminalAndPromptsLanguage(selectedLanguage, new LanguageSwitchListener(){

            public void a() {
                continueAction.run();
            }

            public void b() {
                continueAction.run();
            }

            @Override
            public /* synthetic */ void onOperationSuccess(Object object, Object object2) {
                Accessory cfr_ignored_0 = (Accessory)object;
                Locale cfr_ignored_1 = (Locale)object2;
                this.b();
            }

            @Override
            public /* synthetic */ void onOperationFailure(Object object, MposError mposError) {
                Accessory cfr_ignored_0 = (Accessory)object;
                this.a();
            }
        });
    }

    public void handleDcc(boolean forceNfcDcc, final Runnable continueAction) {
        TransactionProcessor transactionProcessor = this.transactionProcessor;
        if (transactionProcessor instanceof OnlineTransactionProcessor) {
            this.workflowFragment = this.getFragmentFactory().a(this.transaction, (OnlineTransactionProcessor)transactionProcessor, forceNfcDcc, new fG(){

                @Override
                public void a() {
                    continueAction.run();
                }

                @Override
                public void b() {
                    fW.this.abortTransaction(TransactionStatusDetailsCodes.ABORTED_SHOPPER_ABORTED);
                }
            });
            this.workflowFragment.a();
        } else {
            continueAction.run();
        }
    }

    protected boolean overrideDefaultPromptsToCharge() {
        return this.getBehaviors().contains((Object)ProcessingOptions.Behavior.OVERRIDE_DEFAULT_TERMINAL_PROMPTS) && this.transaction.getStatus() == TransactionStatus.APPROVED;
    }
}

