/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.mock;

import io.mpos.logger.LoggerKt;
import io.mpos.mock.Breakpoint;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u001f\u0010\u000f\u001a\u00020\f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0011\"\u00020\n\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/mpos/mock/Breakpoints;", "", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/Lock;", "breakpointCondition", "Ljava/util/concurrent/locks/Condition;", "skipBreakpoints", "", "Lio/mpos/mock/Breakpoint;", "pauseAt", "", "breakpoint", "(Lio/mpos/mock/Breakpoint;)Lkotlin/Unit;", "continueBreakpoints", "breakpoints", "", "([Lio/mpos/mock/Breakpoint;)V", "mpos.core"})
public final class Breakpoints {
    @NotNull
    private final Lock lock = new ReentrantLock();
    @NotNull
    private final Condition breakpointCondition;
    @NotNull
    private final Set<Breakpoint> skipBreakpoints;

    public Breakpoints() {
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"");
        this.breakpointCondition = condition;
        this.skipBreakpoints = new LinkedHashSet();
    }

    @Nullable
    public final Unit pauseAt(@NotNull Breakpoint breakpoint) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"");
        Lock lock = this.lock;
        lock.lock();
        try {
            String cfr_ignored_0 = "Pausing at " + breakpoint;
            while (!this.skipBreakpoints.contains((Object)breakpoint)) {
                if (this.breakpointCondition.await(5000L, TimeUnit.MILLISECONDS)) continue;
                LoggerKt.logError$default("Breakpoints", "Waiting time elapsed for " + breakpoint, null, 4, null);
            }
            unit = LoggerKt.logD((Object)this, "Continuing " + breakpoint);
        }
        finally {
            lock.unlock();
        }
        return unit;
    }

    public final void continueBreakpoints(Breakpoint ... breakpoints) {
        Intrinsics.checkNotNullParameter((Object)breakpoints, (String)"");
        Lock lock = this.lock;
        lock.lock();
        try {
            String cfr_ignored_0 = "Skipping " + ArraysKt.joinToString$default((Object[])breakpoints, null, null, null, (int)0, null, null, (int)63, null);
            CollectionsKt.addAll((Collection)this.skipBreakpoints, (Object[])breakpoints);
            this.breakpointCondition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }
}

