/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.platform;

import io.mpos.errors.ErrorType;
import io.mpos.errors.MposError;
import io.mpos.errors.MposRuntimeException;
import io.mpos.logger.Log;
import io.mpos.shared.errors.DefaultMposError;
import io.mpos.shared.helper.Profiler;

public abstract class AbstractImageHelper {
    private static final int HIGHEST_DIMENSION = 960;
    private static final String NO_IMAGE_ERROR = "The provided image is null";
    private static final String COMPRESSING_MESSAGE_LOG = "Compressing image";
    private static final String SUCCESSFUL_COMPRESSION_LOG_MESSAGE = "Compression finished: initial size %d B, final size %d B, compression time %d ms";
    private static final double BASE64_FACTOR = 1.37;
    private static final int BASE64_HEADER_LENGTH = 814;
    private static final int MAXIMUM_BASE64_LENGTH = 0x180000;
    private static final String BASE64_TOO_BIG_ERROR = "The provided image is too big. Its base64 encoding is higher than 1.5 MB";
    protected static final String RESIZING_START_LOG = "Resizing BufferedImage from %f X %f started";
    protected static final String RESIZING_STOP_LOG = "Resizing BufferedImage to %d X %d successful";
    protected static final String ERROR_CLOSING_OUTPUTSTREAM = "Error closing output stream";
    private final String TAG;
    protected final Profiler profiler;

    public AbstractImageHelper(String tag, Profiler profiler) {
        this.TAG = tag;
        this.profiler = profiler;
    }

    public byte[] compressImage(byte[] image) {
        this.startCompression(image);
        long l2 = System.nanoTime();
        byte[] byArray = this.internalCompressImage(image);
        long l3 = System.nanoTime();
        this.stopCompression(image.length, byArray.length, l2, l3);
        this.failIfBase64ForImageSurpassesLimit(byArray.length);
        return byArray;
    }

    protected abstract byte[] internalCompressImage(byte[] var1);

    protected ResizedDimensions resizeDimensions(double width, double height) {
        double d2 = width / height;
        if (Math.max(width, height) > 960.0) {
            double d3;
            double d4;
            if (width > height) {
                d4 = 960.0;
                d3 = (int)(d4 / d2);
            } else {
                d3 = 960.0;
                d4 = (int)(d3 * d2);
            }
            return new ResizedDimensions(d4, d3);
        }
        return new ResizedDimensions(width, height);
    }

    private void failIfBase64ForImageSurpassesLimit(long compressedImageLength) {
        boolean bl2;
        boolean bl3 = bl2 = (double)compressedImageLength * 1.37 + 814.0 > 1572864.0;
        if (bl2) {
            this.logErrorAndFail(BASE64_TOO_BIG_ERROR);
        }
    }

    private void startCompression(byte[] image) {
        Log.i(this.TAG, COMPRESSING_MESSAGE_LOG);
        this.profiler.beginMeasurement(Profiler.Category.IMAGE_COMPRESSION, COMPRESSING_MESSAGE_LOG);
        if (image == null) {
            this.logErrorAndFail(NO_IMAGE_ERROR);
        }
    }

    private void stopCompression(long initialSize, long finalSize, double startCompression, double endCompression) {
        double d2 = (endCompression - startCompression) / 1000000.0;
        this.profiler.endMeasurement(Profiler.Category.IMAGE_COMPRESSION, String.format(SUCCESSFUL_COMPRESSION_LOG_MESSAGE, initialSize, finalSize, (long)d2));
        Log.i(this.TAG, String.format(SUCCESSFUL_COMPRESSION_LOG_MESSAGE, initialSize, finalSize, (long)d2));
    }

    private byte[] logErrorAndFail(String invalidImageError) {
        Log.e(this.TAG, invalidImageError);
        this.profiler.endMeasurementWithError(Profiler.Category.IMAGE_COMPRESSION, invalidImageError);
        throw new MposRuntimeException((MposError)new DefaultMposError(ErrorType.TRANSACTION_ACTION_ERROR, invalidImageError));
    }

    protected class ResizedDimensions {
        private double width;
        private double height;

        public ResizedDimensions(double width, double height) {
            this.width = width;
            this.height = height;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }
    }
}

