/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.platform;

import io.mpos.platform.SdkInformation;
import java.text.DateFormat;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public interface DeviceInformation {
    public String getDeviceIdentifier();

    public OperatingSystem getOperatingSystem();

    public String getManufacturer();

    public String getDeviceName();

    public String getVersion();

    @NotNull
    public Locale getLocale();

    public DateFormat getISO8601DateFormat();

    public SdkInformation getSdkInformation();

    public static enum OperatingSystem {
        ANDROID("Android"),
        WINDOWS("Windows"),
        LINUX("Linux"),
        OSX("Mac OS X"),
        GENERIC("Generic");

        private final String mOsName;

        private OperatingSystem(String osName) {
            this.mOsName = osName;
        }

        public boolean equalsName(String otherName) {
            return otherName != null && this.mOsName.equals(otherName);
        }

        public String toString() {
            return this.mOsName;
        }
    }
}

