/*
 * Decompiled with CFR 0.152.
 */
package io.mpos.provider.listener;

import io.mpos.core.common.obfuscated.dB;
import io.mpos.core.common.obfuscated.dz;
import io.mpos.core.common.obfuscated.eo;
import io.mpos.errors.MposError;
import io.mpos.provider.Provider;
import io.mpos.provider.listener.IncrementalAuthorizationTransactionListener;
import io.mpos.shared.helper.Profiler;
import io.mpos.shared.transactionprovider.ProcessTracker;
import io.mpos.shared.transactions.BaseTransaction;
import io.mpos.transactionprovider.TransactionProcessDetailsState;
import io.mpos.transactionprovider.TransactionProcessDetailsStateDetails;
import io.mpos.transactions.TransactionType;
import io.mpos.transactions.parameters.TransactionParameters;

public class DefaultIncrementalAuthorizationTransactionListener
implements IncrementalAuthorizationTransactionListener {
    private final dB statusHandler;
    private final TransactionParameters transactionParameters;
    private final Profiler profiler;
    private final Provider provider;
    private final ProcessTracker processTracker;
    private BaseTransaction transaction;

    public DefaultIncrementalAuthorizationTransactionListener(dB statusHandler, TransactionParameters transactionParameters, Profiler profiler, Provider provider, ProcessTracker processTracker) {
        this.statusHandler = statusHandler;
        this.transactionParameters = transactionParameters;
        this.profiler = profiler;
        this.provider = provider;
        this.processTracker = processTracker;
        this.transaction = null;
    }

    @Override
    public void onIncrementalAuthorizationTransactionApproved(TransactionParameters transactionParameters, BaseTransaction transaction) {
        if (this.transactionParameters.equals(transactionParameters)) {
            this.transaction = transaction;
            this.statusHandler.a(transaction);
            this.statusHandler.a(TransactionProcessDetailsState.APPROVED, TransactionProcessDetailsStateDetails.APPROVED, TransactionType.INCREMENTAL_AUTHORIZATION);
            this.complete(transaction);
        }
    }

    @Override
    public void onIncrementalAuthorizationTransactionFailure(TransactionParameters transactionParameters, MposError error, BaseTransaction transaction) {
        if (this.transactionParameters.equals(transactionParameters)) {
            boolean bl2 = eo.b(error);
            this.statusHandler.a(error, bl2, dz.a(transactionParameters));
            this.complete(transaction);
        }
    }

    public BaseTransaction getTransaction() {
        return this.transaction;
    }

    private void complete(BaseTransaction transaction) {
        String string = transaction != null ? "completed transaction with result : " + transaction.getStatus() : "completed without transaction";
        this.profiler.endMeasurement(Profiler.Category.TRANSACTION_PROVIDER_TRANSACTION_PROCESS, string);
        this.profiler.persistFromTriggerSource(Profiler.TriggerSource.TRANSACTION_PROVIDER);
        this.statusHandler.d();
        this.teardown();
    }

    private void teardown() {
        this.processTracker.decrementNonCardProcessOngoing();
        this.provider.removeIncrementalAuthorizationTransactionListener(this);
    }
}

